/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.okta.sdk.resource.model.NetworkZone;
import com.okta.sdk.resource.model.NetworkZoneAddress;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"useAsExemptList", "gateways", "proxies"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true, defaultImpl=IPNetworkZone.class)
public class IPNetworkZone
extends NetworkZone
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_USE_AS_EXEMPT_LIST = "useAsExemptList";
    private Boolean useAsExemptList;
    public static final String JSON_PROPERTY_GATEWAYS = "gateways";
    private List<NetworkZoneAddress> gateways = null;
    public static final String JSON_PROPERTY_PROXIES = "proxies";
    private JsonNullable<List<NetworkZoneAddress>> proxies = JsonNullable.undefined();

    public IPNetworkZone useAsExemptList(Boolean useAsExemptList) {
        this.useAsExemptList = useAsExemptList;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="You can **only** use this parameter when making a request to the Replace the network zone endpoint (`/api/v1/zones/{zoneId}`). Set this parameter to `true` in your request when you update the `DefaultExemptIpZone` to allow IPs through the blocklist.")
    @JsonProperty(value="useAsExemptList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getUseAsExemptList() {
        return this.useAsExemptList;
    }

    @JsonProperty(value="useAsExemptList")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseAsExemptList(Boolean useAsExemptList) {
        this.useAsExemptList = useAsExemptList;
    }

    public IPNetworkZone gateways(List<NetworkZoneAddress> gateways) {
        this.gateways = gateways;
        return this;
    }

    public IPNetworkZone addgatewaysItem(NetworkZoneAddress gatewaysItem) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<NetworkZoneAddress>();
        }
        this.gateways.add(gatewaysItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The IP addresses (range or CIDR form) for an IP Network Zone. The maximum array length is 150 entries for admin-created IP zones, 1000 entries for IP blocklist zones, and 5000 entries for the default system IP Zone.")
    @JsonProperty(value="gateways")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<NetworkZoneAddress> getGateways() {
        return this.gateways;
    }

    @JsonProperty(value="gateways")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGateways(List<NetworkZoneAddress> gateways) {
        this.gateways = gateways;
    }

    public IPNetworkZone proxies(List<NetworkZoneAddress> proxies) {
        this.proxies = JsonNullable.of(proxies);
        return this;
    }

    public IPNetworkZone addproxiesItem(NetworkZoneAddress proxiesItem) {
        if (this.proxies == null || !this.proxies.isPresent()) {
            this.proxies = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.proxies.get()).add(proxiesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The IP addresses (range or CIDR form) that are allowed to forward a request from gateway addresses for an IP Network Zone. These proxies are automatically trusted by Threat Insights and used to identify the client IP of a request. The maximum array length is 150 entries for admin-created zones and 5000 entries for the default system IP Zone.")
    @JsonIgnore
    public List<NetworkZoneAddress> getProxies() {
        return (List)this.proxies.orElse(null);
    }

    @JsonProperty(value="proxies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<NetworkZoneAddress>> getProxies_JsonNullable() {
        return this.proxies;
    }

    @JsonProperty(value="proxies")
    public void setProxies_JsonNullable(JsonNullable<List<NetworkZoneAddress>> proxies) {
        this.proxies = proxies;
    }

    public void setProxies(List<NetworkZoneAddress> proxies) {
        this.proxies = JsonNullable.of(proxies);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPNetworkZone ipNetworkZone = (IPNetworkZone)o;
        return Objects.equals(this.useAsExemptList, ipNetworkZone.useAsExemptList) && Objects.equals(this.gateways, ipNetworkZone.gateways) && IPNetworkZone.equalsNullable(this.proxies, ipNetworkZone.proxies);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.useAsExemptList, this.gateways, IPNetworkZone.hashCodeNullable(this.proxies), super.hashCode());
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IPNetworkZone {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    useAsExemptList: ").append(this.toIndentedString(this.useAsExemptList)).append("\n");
        sb.append("    gateways: ").append(this.toIndentedString(this.gateways)).append("\n");
        sb.append("    proxies: ").append(this.toIndentedString(this.proxies)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

