/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Statistics about the group")
@JsonPropertyOrder(value={"usersCount", "appsCount", "groupPushMappingsCount", "hasAdminPrivlege"})
@JsonTypeName(value="Group__embedded_stats")
public class GroupEmbeddedStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_USERS_COUNT = "usersCount";
    private Integer usersCount;
    public static final String JSON_PROPERTY_APPS_COUNT = "appsCount";
    private Integer appsCount;
    public static final String JSON_PROPERTY_GROUP_PUSH_MAPPINGS_COUNT = "groupPushMappingsCount";
    private Integer groupPushMappingsCount;
    public static final String JSON_PROPERTY_HAS_ADMIN_PRIVLEGE = "hasAdminPrivlege";
    private Boolean hasAdminPrivlege;

    public GroupEmbeddedStats usersCount(Integer usersCount) {
        this.usersCount = usersCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of users in the group")
    @JsonProperty(value="usersCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getUsersCount() {
        return this.usersCount;
    }

    @JsonProperty(value="usersCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsersCount(Integer usersCount) {
        this.usersCount = usersCount;
    }

    public GroupEmbeddedStats appsCount(Integer appsCount) {
        this.appsCount = appsCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of apps associated with the group")
    @JsonProperty(value="appsCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAppsCount() {
        return this.appsCount;
    }

    @JsonProperty(value="appsCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppsCount(Integer appsCount) {
        this.appsCount = appsCount;
    }

    public GroupEmbeddedStats groupPushMappingsCount(Integer groupPushMappingsCount) {
        this.groupPushMappingsCount = groupPushMappingsCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of group push mappings associated with the group")
    @JsonProperty(value="groupPushMappingsCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getGroupPushMappingsCount() {
        return this.groupPushMappingsCount;
    }

    @JsonProperty(value="groupPushMappingsCount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGroupPushMappingsCount(Integer groupPushMappingsCount) {
        this.groupPushMappingsCount = groupPushMappingsCount;
    }

    public GroupEmbeddedStats hasAdminPrivlege(Boolean hasAdminPrivlege) {
        this.hasAdminPrivlege = hasAdminPrivlege;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if the group has admin privileges via a group-level role assignment")
    @JsonProperty(value="hasAdminPrivlege")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHasAdminPrivlege() {
        return this.hasAdminPrivlege;
    }

    @JsonProperty(value="hasAdminPrivlege")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasAdminPrivlege(Boolean hasAdminPrivlege) {
        this.hasAdminPrivlege = hasAdminPrivlege;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupEmbeddedStats groupEmbeddedStats = (GroupEmbeddedStats)o;
        return Objects.equals(this.usersCount, groupEmbeddedStats.usersCount) && Objects.equals(this.appsCount, groupEmbeddedStats.appsCount) && Objects.equals(this.groupPushMappingsCount, groupEmbeddedStats.groupPushMappingsCount) && Objects.equals(this.hasAdminPrivlege, groupEmbeddedStats.hasAdminPrivlege);
    }

    public int hashCode() {
        return Objects.hash(this.usersCount, this.appsCount, this.groupPushMappingsCount, this.hasAdminPrivlege);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupEmbeddedStats {\n");
        sb.append("    usersCount: ").append(this.toIndentedString(this.usersCount)).append("\n");
        sb.append("    appsCount: ").append(this.toIndentedString(this.appsCount)).append("\n");
        sb.append("    groupPushMappingsCount: ").append(this.toIndentedString(this.groupPushMappingsCount)).append("\n");
        sb.append("    hasAdminPrivlege: ").append(this.toIndentedString(this.hasAdminPrivlege)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

