/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="If the group is sourced from an app, this object contains information about that app")
@JsonPropertyOrder(value={"id", "name", "label", "signOnMode"})
@JsonTypeName(value="Group__embedded_app")
public class GroupEmbeddedApp
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_SIGN_ON_MODE = "signOnMode";
    private String signOnMode;

    public GroupEmbeddedApp id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the `AppInstance`")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public GroupEmbeddedApp name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the `AppInstance`")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public GroupEmbeddedApp label(String label) {
        this.label = label;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user-facing display name of the `AppInstance`")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabel(String label) {
        this.label = label;
    }

    public GroupEmbeddedApp signOnMode(String signOnMode) {
        this.signOnMode = signOnMode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SAML_1_1", value="The configured sign-on mode for the `AppInstance`")
    @JsonProperty(value="signOnMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSignOnMode() {
        return this.signOnMode;
    }

    @JsonProperty(value="signOnMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignOnMode(String signOnMode) {
        this.signOnMode = signOnMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupEmbeddedApp groupEmbeddedApp = (GroupEmbeddedApp)o;
        return Objects.equals(this.id, groupEmbeddedApp.id) && Objects.equals(this.name, groupEmbeddedApp.name) && Objects.equals(this.label, groupEmbeddedApp.label) && Objects.equals(this.signOnMode, groupEmbeddedApp.signOnMode);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.label, this.signOnMode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GroupEmbeddedApp {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    signOnMode: ").append(this.toIndentedString(this.signOnMode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

