/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AgentSecretLinks;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="An RSA signing key")
@JsonPropertyOrder(value={"e", "kty", "n", "kid", "status", "alg", "use", "created", "id", "lastUpdated", "_links"})
public class AgentJsonWebKeyRsaResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_E = "e";
    private String e;
    public static final String JSON_PROPERTY_KTY = "kty";
    private KtyEnum kty;
    public static final String JSON_PROPERTY_N = "n";
    private String n;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status = StatusEnum.ACTIVE;
    public static final String JSON_PROPERTY_ALG = "alg";
    private String alg;
    public static final String JSON_PROPERTY_USE = "use";
    private UseEnum use;
    public static final String JSON_PROPERTY_CREATED = "created";
    private String created;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private String lastUpdated;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private AgentSecretLinks links;

    public AgentJsonWebKeyRsaResponse e(String e) {
        this.e = e;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="AQAB", value="The public exponent of the RSA key, represented as a Base64URL-encoded string.  This value is used in combination with the modulus (`n`) to verify signatures and encrypt data.")
    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getE() {
        return this.e;
    }

    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setE(String e) {
        this.e = e;
    }

    public AgentJsonWebKeyRsaResponse kty(KtyEnum kty) {
        this.kty = kty;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="RSA", required=true, value="Cryptographic algorithm family for the certificate's key pair")
    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public KtyEnum getKty() {
        return this.kty;
    }

    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKty(KtyEnum kty) {
        this.kty = kty;
    }

    public AgentJsonWebKeyRsaResponse n(String n) {
        this.n = n;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="mkC6yAJVvFwUlmM9gKjb2d-YK5qHFt-mXSsbjWKKs4EfNm-BoQeeovBZtSACyaqLc8IYFTPEURFcbDQ9DkAL04uUIRD2gaHYY7uK0jsluEaXGq2RAIsmzAwNTzkiDw4q9pDL_q7n0f_SDt1TsMaMQayB6bU5jWsmqcWJ8MCRJ1aJMjZ16un5UVx51IIeCbe4QRDxEXGAvYNczsBoZxspDt28esSpq5W0dBFxcyGVudyl54Er3FzAguhgfMVjH-bUec9j2Tl40qDTktrYgYfxz9pfjm01Hl4WYP1YQxeETpSL7cQ5Ihz4jGDtHUEOcZ4GfJrPzrGpUrak8Qp5xcwCqQ", value="The modulus of the RSA public key, represented as a Base64URL-encoded string.  This is the primary component of the RSA key and, with the exponent (`e`), is used for cryptographic signature verification and encryption.")
    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getN() {
        return this.n;
    }

    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setN(String n) {
        this.n = n;
    }

    public AgentJsonWebKeyRsaResponse kid(String kid) {
        this.kid = kid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="SIMcCQNY3uwXoW3y0vf6VxiBb5n9pf8L2fK8d-FIbm4", value="Unique identifier of the JSON Web Key in the AI agent's JSON Web Key Set (JWKS)")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKid() {
        return this.kid;
    }

    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKid(String kid) {
        this.kid = kid;
    }

    public AgentJsonWebKeyRsaResponse status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="ACTIVE", value="Status of the AI agent JSON Web Key")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AgentJsonWebKeyRsaResponse alg(String alg) {
        this.alg = alg;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="RS256", value="Algorithm that's used in the JSON Web Key")
    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlg(String alg) {
        this.alg = alg;
    }

    public AgentJsonWebKeyRsaResponse use(UseEnum use) {
        this.use = use;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="sig", value="Acceptable use of the JSON Web Key  You can only use signing keys for AI agents, so the value of `use` is always `sig`.")
    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UseEnum getUse() {
        return this.use;
    }

    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUse(UseEnum use) {
        this.use = use;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-21T20:08:24.000Z", value="Timestamp of when the AI agent JSON Web Key was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(example="pks2f4zrZbs8nUa7p0g4", value="The unique ID of the AI agent JSON Web Key")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(example="2023-02-21T20:08:24.000Z", value="Timestamp of when the AI agent JSON Web Key was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public AgentJsonWebKeyRsaResponse links(AgentSecretLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AgentSecretLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(AgentSecretLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentJsonWebKeyRsaResponse agentJsonWebKeyRsaResponse = (AgentJsonWebKeyRsaResponse)o;
        return Objects.equals(this.e, agentJsonWebKeyRsaResponse.e) && Objects.equals((Object)this.kty, (Object)agentJsonWebKeyRsaResponse.kty) && Objects.equals(this.n, agentJsonWebKeyRsaResponse.n) && Objects.equals(this.kid, agentJsonWebKeyRsaResponse.kid) && Objects.equals((Object)this.status, (Object)agentJsonWebKeyRsaResponse.status) && Objects.equals(this.alg, agentJsonWebKeyRsaResponse.alg) && Objects.equals((Object)this.use, (Object)agentJsonWebKeyRsaResponse.use) && Objects.equals(this.created, agentJsonWebKeyRsaResponse.created) && Objects.equals(this.id, agentJsonWebKeyRsaResponse.id) && Objects.equals(this.lastUpdated, agentJsonWebKeyRsaResponse.lastUpdated) && Objects.equals(this.links, agentJsonWebKeyRsaResponse.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.e, this.kty, this.n, this.kid, this.status, this.alg, this.use, this.created, this.id, this.lastUpdated, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentJsonWebKeyRsaResponse {\n");
        sb.append("    e: ").append(this.toIndentedString(this.e)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString((Object)this.kty)).append("\n");
        sb.append("    n: ").append(this.toIndentedString(this.n)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    use: ").append(this.toIndentedString((Object)this.use)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("ACTIVE")),
        INACTIVE(String.valueOf("INACTIVE")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum KtyEnum {
        RSA(String.valueOf("RSA")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private KtyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KtyEnum fromValue(String value) {
            for (KtyEnum b : KtyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum UseEnum {
        SIG(String.valueOf("sig")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private UseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UseEnum fromValue(String value) {
            for (UseEnum b : UseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

