/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.CreateGroupPushMappingRequest;
import com.okta.sdk.resource.model.GroupPushMapping;
import com.okta.sdk.resource.model.GroupPushMappingStatus;
import com.okta.sdk.resource.model.UpdateGroupPushMappingRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class GroupPushMappingApi {
    private ApiClient apiClient;

    public GroupPushMappingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GroupPushMappingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public GroupPushMapping createGroupPushMapping(String appId, CreateGroupPushMappingRequest body) throws ApiException {
        return this.createGroupPushMapping(appId, body, Collections.emptyMap());
    }

    public GroupPushMapping createGroupPushMapping(String appId, CreateGroupPushMappingRequest body, Map<String, String> additionalHeaders) throws ApiException {
        CreateGroupPushMappingRequest localVarPostBody = body;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling createGroupPushMapping");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createGroupPushMapping");
        }
        String localVarPath = "/api/v1/apps/{appId}/group-push/mappings".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<GroupPushMapping> localVarReturnType = new TypeReference<GroupPushMapping>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteGroupPushMapping(String appId, String mappingId, Boolean deleteTargetGroup) throws ApiException {
        this.deleteGroupPushMapping(appId, mappingId, deleteTargetGroup, Collections.emptyMap());
    }

    public void deleteGroupPushMapping(String appId, String mappingId, Boolean deleteTargetGroup, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling deleteGroupPushMapping");
        }
        if (mappingId == null) {
            throw new ApiException(400, "Missing the required parameter 'mappingId' when calling deleteGroupPushMapping");
        }
        if (deleteTargetGroup == null) {
            throw new ApiException(400, "Missing the required parameter 'deleteTargetGroup' when calling deleteGroupPushMapping");
        }
        String localVarPath = "/api/v1/apps/{appId}/group-push/mappings/{mappingId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{mappingId\\}", this.apiClient.escapeString(mappingId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("deleteTargetGroup", deleteTargetGroup));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public GroupPushMapping getGroupPushMapping(String appId, String mappingId) throws ApiException {
        return this.getGroupPushMapping(appId, mappingId, Collections.emptyMap());
    }

    public GroupPushMapping getGroupPushMapping(String appId, String mappingId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling getGroupPushMapping");
        }
        if (mappingId == null) {
            throw new ApiException(400, "Missing the required parameter 'mappingId' when calling getGroupPushMapping");
        }
        String localVarPath = "/api/v1/apps/{appId}/group-push/mappings/{mappingId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{mappingId\\}", this.apiClient.escapeString(mappingId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<GroupPushMapping> localVarReturnType = new TypeReference<GroupPushMapping>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<GroupPushMapping> listGroupPushMappings(String appId, String after, Integer limit, String lastUpdated, String sourceGroupId, GroupPushMappingStatus status) throws ApiException {
        return this.listGroupPushMappings(appId, after, limit, lastUpdated, sourceGroupId, status, Collections.emptyMap());
    }

    public List<GroupPushMapping> listGroupPushMappings(String appId, String after, Integer limit, String lastUpdated, String sourceGroupId, GroupPushMappingStatus status, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling listGroupPushMappings");
        }
        String localVarPath = "/api/v1/apps/{appId}/group-push/mappings".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("lastUpdated", lastUpdated));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sourceGroupId", sourceGroupId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("status", (Object)status));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<GroupPushMapping>> localVarReturnType = new TypeReference<List<GroupPushMapping>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<GroupPushMapping> listGroupPushMappingsPaged(String appId, String after, Integer limit, String lastUpdated, String sourceGroupId, GroupPushMappingStatus status) {
        return this.listGroupPushMappingsPaged(appId, after, limit, lastUpdated, sourceGroupId, status, Collections.emptyMap());
    }

    public Iterable<GroupPushMapping> listGroupPushMappingsPaged(String appId, String after, Integer limit, String lastUpdated, String sourceGroupId, GroupPushMappingStatus status, Map<String, String> additionalHeaders) {
        return new PagedIterable<GroupPushMapping>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/apps/{appId}/group-push/mappings".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("lastUpdated", lastUpdated));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("sourceGroupId", sourceGroupId));
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("status", (Object)status));
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<GroupPushMapping>> localVarReturnType = new TypeReference<List<GroupPushMapping>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<GroupPushMapping>> localVarReturnType = new TypeReference<List<GroupPushMapping>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public GroupPushMapping updateGroupPushMapping(String appId, String mappingId, UpdateGroupPushMappingRequest body) throws ApiException {
        return this.updateGroupPushMapping(appId, mappingId, body, Collections.emptyMap());
    }

    public GroupPushMapping updateGroupPushMapping(String appId, String mappingId, UpdateGroupPushMappingRequest body, Map<String, String> additionalHeaders) throws ApiException {
        UpdateGroupPushMappingRequest localVarPostBody = body;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling updateGroupPushMapping");
        }
        if (mappingId == null) {
            throw new ApiException(400, "Missing the required parameter 'mappingId' when calling updateGroupPushMapping");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateGroupPushMapping");
        }
        String localVarPath = "/api/v1/apps/{appId}/group-push/mappings/{mappingId}".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString())).replaceAll("\\{mappingId\\}", this.apiClient.escapeString(mappingId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<GroupPushMapping> localVarReturnType = new TypeReference<GroupPushMapping>(){};
        return this.apiClient.invokeAPI(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

