/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SamlAlgorithms;
import com.okta.sdk.resource.model.SamlCredentials;
import com.okta.sdk.resource.model.SamlEndpoints;
import com.okta.sdk.resource.model.SamlRelayState;
import com.okta.sdk.resource.model.SamlSettings;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Protocol settings for the [SAML 2.0 Authentication Request Protocol](http://docs.oasis-open.org/security/saml/v2.0/saml-core-2.0-os.pdf)")
@JsonPropertyOrder(value={"algorithms", "credentials", "endpoints", "relayState", "settings", "type"})
public class ProtocolSaml
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ALGORITHMS = "algorithms";
    private SamlAlgorithms algorithms;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private SamlCredentials credentials;
    public static final String JSON_PROPERTY_ENDPOINTS = "endpoints";
    private SamlEndpoints endpoints;
    public static final String JSON_PROPERTY_RELAY_STATE = "relayState";
    private SamlRelayState relayState;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private SamlSettings settings;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public ProtocolSaml algorithms(SamlAlgorithms algorithms) {
        this.algorithms = algorithms;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="algorithms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SamlAlgorithms getAlgorithms() {
        return this.algorithms;
    }

    @JsonProperty(value="algorithms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithms(SamlAlgorithms algorithms) {
        this.algorithms = algorithms;
    }

    public ProtocolSaml credentials(SamlCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SamlCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(SamlCredentials credentials) {
        this.credentials = credentials;
    }

    public ProtocolSaml endpoints(SamlEndpoints endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SamlEndpoints getEndpoints() {
        return this.endpoints;
    }

    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndpoints(SamlEndpoints endpoints) {
        this.endpoints = endpoints;
    }

    public ProtocolSaml relayState(SamlRelayState relayState) {
        this.relayState = relayState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="relayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SamlRelayState getRelayState() {
        return this.relayState;
    }

    @JsonProperty(value="relayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelayState(SamlRelayState relayState) {
        this.relayState = relayState;
    }

    public ProtocolSaml settings(SamlSettings settings) {
        this.settings = settings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SamlSettings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(SamlSettings settings) {
        this.settings = settings;
    }

    public ProtocolSaml type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SAML 2.0 protocol")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtocolSaml protocolSaml = (ProtocolSaml)o;
        return Objects.equals(this.algorithms, protocolSaml.algorithms) && Objects.equals(this.credentials, protocolSaml.credentials) && Objects.equals(this.endpoints, protocolSaml.endpoints) && Objects.equals(this.relayState, protocolSaml.relayState) && Objects.equals(this.settings, protocolSaml.settings) && Objects.equals((Object)this.type, (Object)protocolSaml.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithms, this.credentials, this.endpoints, this.relayState, this.settings, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProtocolSaml {\n");
        sb.append("    algorithms: ").append(this.toIndentedString(this.algorithms)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    relayState: ").append(this.toIndentedString(this.relayState)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        SAML2(String.valueOf("SAML2")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

