/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.PagedIterable;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.ProviderType;
import com.okta.sdk.resource.model.PushProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class PushProviderApi {
    private ApiClient apiClient;

    public PushProviderApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PushProviderApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public PushProvider createPushProvider(PushProvider pushProvider) throws ApiException {
        return this.createPushProvider(pushProvider, Collections.emptyMap());
    }

    public PushProvider createPushProvider(PushProvider pushProvider, Map<String, String> additionalHeaders) throws ApiException {
        PushProvider localVarPostBody = pushProvider;
        if (pushProvider == null) {
            throw new ApiException(400, "Missing the required parameter 'pushProvider' when calling createPushProvider");
        }
        String localVarPath = "/api/v1/push-providers";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<PushProvider> localVarReturnType = new TypeReference<PushProvider>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deletePushProvider(String pushProviderId) throws ApiException {
        this.deletePushProvider(pushProviderId, Collections.emptyMap());
    }

    public void deletePushProvider(String pushProviderId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pushProviderId == null) {
            throw new ApiException(400, "Missing the required parameter 'pushProviderId' when calling deletePushProvider");
        }
        String localVarPath = "/api/v1/push-providers/{pushProviderId}".replaceAll("\\{pushProviderId\\}", this.apiClient.escapeString(pushProviderId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public PushProvider getPushProvider(String pushProviderId) throws ApiException {
        return this.getPushProvider(pushProviderId, Collections.emptyMap());
    }

    public PushProvider getPushProvider(String pushProviderId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (pushProviderId == null) {
            throw new ApiException(400, "Missing the required parameter 'pushProviderId' when calling getPushProvider");
        }
        String localVarPath = "/api/v1/push-providers/{pushProviderId}".replaceAll("\\{pushProviderId\\}", this.apiClient.escapeString(pushProviderId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<PushProvider> localVarReturnType = new TypeReference<PushProvider>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<PushProvider> listPushProviders(ProviderType type) throws ApiException {
        return this.listPushProviders(type, Collections.emptyMap());
    }

    public List<PushProvider> listPushProviders(ProviderType type, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/push-providers";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("type", (Object)type));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<PushProvider>> localVarReturnType = new TypeReference<List<PushProvider>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Iterable<PushProvider> listPushProvidersPaged(ProviderType type) {
        return this.listPushProvidersPaged(type, Collections.emptyMap());
    }

    public Iterable<PushProvider> listPushProvidersPaged(ProviderType type, Map<String, String> additionalHeaders) {
        return new PagedIterable<PushProvider>(nextUrl -> {
            try {
                if (nextUrl == null) {
                    Object localVarPostBody = null;
                    String localVarPath = "/api/v1/push-providers";
                    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
                    ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
                    ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
                    localVarQueryParams.addAll(this.apiClient.parameterToPair("type", (Object)type));
                    HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                    localVarHeaderParams.putAll(additionalHeaders);
                    String[] localVarAccepts = new String[]{"application/json"};
                    String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
                    String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                    String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                    String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                    TypeReference<List<PushProvider>> localVarReturnType = new TypeReference<List<PushProvider>>(){};
                    return this.apiClient.invokeAPIWithHttpInfo(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, new HashMap<String, String>(), new HashMap<String, Object>(), localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
                }
                HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
                localVarHeaderParams.putAll(additionalHeaders);
                String[] localVarAccepts = new String[]{"application/json"};
                String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, (String)nextUrl);
                String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
                String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
                String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
                TypeReference<List<PushProvider>> localVarReturnType = new TypeReference<List<PushProvider>>(){};
                return this.apiClient.invokeAPIWithHttpInfoFullURL((String)nextUrl, "GET", (Map<String, String>)localVarHeaderParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
            }
            catch (ApiException e) {
                throw new RuntimeException("Failed to fetch page", e);
            }
        });
    }

    public PushProvider replacePushProvider(String pushProviderId, PushProvider pushProvider) throws ApiException {
        return this.replacePushProvider(pushProviderId, pushProvider, Collections.emptyMap());
    }

    public PushProvider replacePushProvider(String pushProviderId, PushProvider pushProvider, Map<String, String> additionalHeaders) throws ApiException {
        PushProvider localVarPostBody = pushProvider;
        if (pushProviderId == null) {
            throw new ApiException(400, "Missing the required parameter 'pushProviderId' when calling replacePushProvider");
        }
        if (pushProvider == null) {
            throw new ApiException(400, "Missing the required parameter 'pushProvider' when calling replacePushProvider");
        }
        String localVarPath = "/api/v1/push-providers/{pushProviderId}".replaceAll("\\{pushProviderId\\}", this.apiClient.escapeString(pushProviderId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<PushProvider> localVarReturnType = new TypeReference<PushProvider>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

