/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.ApplicationSettingsNotes;
import com.okta.sdk.resource.model.ApplicationSettingsNotifications;
import com.okta.sdk.resource.model.SamlApplicationSettingsSignOn;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"identityStoreId", "implicitAssignment", "inlineHookId", "notes", "notifications", "signOn", "app"})
public class SamlApplicationSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_IDENTITY_STORE_ID = "identityStoreId";
    private String identityStoreId;
    public static final String JSON_PROPERTY_IMPLICIT_ASSIGNMENT = "implicitAssignment";
    private Boolean implicitAssignment;
    public static final String JSON_PROPERTY_INLINE_HOOK_ID = "inlineHookId";
    private String inlineHookId;
    public static final String JSON_PROPERTY_NOTES = "notes";
    private ApplicationSettingsNotes notes;
    public static final String JSON_PROPERTY_NOTIFICATIONS = "notifications";
    private ApplicationSettingsNotifications notifications;
    public static final String JSON_PROPERTY_SIGN_ON = "signOn";
    private SamlApplicationSettingsSignOn signOn;
    public static final String JSON_PROPERTY_APP = "app";
    private Map<String, Object> app = null;

    public SamlApplicationSettings identityStoreId(String identityStoreId) {
        this.identityStoreId = identityStoreId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifies an additional identity store app, if your app supports it. The `identityStoreId` value must be a valid identity store app ID. This identity store app must be created in the same org as your app.")
    @JsonProperty(value="identityStoreId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdentityStoreId() {
        return this.identityStoreId;
    }

    @JsonProperty(value="identityStoreId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdentityStoreId(String identityStoreId) {
        this.identityStoreId = identityStoreId;
    }

    public SamlApplicationSettings implicitAssignment(Boolean implicitAssignment) {
        this.implicitAssignment = implicitAssignment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Controls whether Okta automatically assigns users to the app based on the user's role or group membership.")
    @JsonProperty(value="implicitAssignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getImplicitAssignment() {
        return this.implicitAssignment;
    }

    @JsonProperty(value="implicitAssignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setImplicitAssignment(Boolean implicitAssignment) {
        this.implicitAssignment = implicitAssignment;
    }

    public SamlApplicationSettings inlineHookId(String inlineHookId) {
        this.inlineHookId = inlineHookId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifier of an inline hook. Inline hooks are outbound calls from Okta to your own custom code, triggered at specific points in Okta process flows. They allow you to integrate custom functionality into those flows. See [Inline hooks](/openapi/okta-management/management/tag/InlineHook/).")
    @JsonProperty(value="inlineHookId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInlineHookId() {
        return this.inlineHookId;
    }

    @JsonProperty(value="inlineHookId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInlineHookId(String inlineHookId) {
        this.inlineHookId = inlineHookId;
    }

    public SamlApplicationSettings notes(ApplicationSettingsNotes notes) {
        this.notes = notes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="notes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationSettingsNotes getNotes() {
        return this.notes;
    }

    @JsonProperty(value="notes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotes(ApplicationSettingsNotes notes) {
        this.notes = notes;
    }

    public SamlApplicationSettings notifications(ApplicationSettingsNotifications notifications) {
        this.notifications = notifications;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="notifications")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationSettingsNotifications getNotifications() {
        return this.notifications;
    }

    @JsonProperty(value="notifications")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNotifications(ApplicationSettingsNotifications notifications) {
        this.notifications = notifications;
    }

    public SamlApplicationSettings signOn(SamlApplicationSettingsSignOn signOn) {
        this.signOn = signOn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="signOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SamlApplicationSettingsSignOn getSignOn() {
        return this.signOn;
    }

    @JsonProperty(value="signOn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSignOn(SamlApplicationSettingsSignOn signOn) {
        this.signOn = signOn;
    }

    public SamlApplicationSettings app(Map<String, Object> app) {
        this.app = app;
        return this;
    }

    public SamlApplicationSettings putappItem(String key, Object appItem) {
        if (this.app == null) {
            this.app = new HashMap<String, Object>();
        }
        this.app.put(key, appItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required placeholder to save defaultRelayState")
    @JsonProperty(value="app")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getApp() {
        return this.app;
    }

    @JsonProperty(value="app")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setApp(Map<String, Object> app) {
        this.app = app;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlApplicationSettings samlApplicationSettings = (SamlApplicationSettings)o;
        return Objects.equals(this.identityStoreId, samlApplicationSettings.identityStoreId) && Objects.equals(this.implicitAssignment, samlApplicationSettings.implicitAssignment) && Objects.equals(this.inlineHookId, samlApplicationSettings.inlineHookId) && Objects.equals(this.notes, samlApplicationSettings.notes) && Objects.equals(this.notifications, samlApplicationSettings.notifications) && Objects.equals(this.signOn, samlApplicationSettings.signOn) && Objects.equals(this.app, samlApplicationSettings.app);
    }

    public int hashCode() {
        return Objects.hash(this.identityStoreId, this.implicitAssignment, this.inlineHookId, this.notes, this.notifications, this.signOn, this.app);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlApplicationSettings {\n");
        sb.append("    identityStoreId: ").append(this.toIndentedString(this.identityStoreId)).append("\n");
        sb.append("    implicitAssignment: ").append(this.toIndentedString(this.implicitAssignment)).append("\n");
        sb.append("    inlineHookId: ").append(this.toIndentedString(this.inlineHookId)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    notifications: ").append(this.toIndentedString(this.notifications)).append("\n");
        sb.append("    signOn: ").append(this.toIndentedString(this.signOn)).append("\n");
        sb.append("    app: ").append(this.toIndentedString(this.app)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

