/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.CredentialSyncState;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"errorCode", "errorReason", "secretVersionId", "syncState", "syncTime"})
public class CredentialSyncInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
    private String errorCode;
    public static final String JSON_PROPERTY_ERROR_REASON = "errorReason";
    private String errorReason;
    public static final String JSON_PROPERTY_SECRET_VERSION_ID = "secretVersionId";
    private String secretVersionId;
    public static final String JSON_PROPERTY_SYNC_STATE = "syncState";
    private CredentialSyncState syncState;
    public static final String JSON_PROPERTY_SYNC_TIME = "syncTime";
    private OffsetDateTime syncTime;

    @Nullable
    @ApiModelProperty(value="The error code for the type of error")
    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    @ApiModelProperty(value="A short description of the error")
    @JsonProperty(value="errorReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorReason() {
        return this.errorReason;
    }

    public CredentialSyncInfo secretVersionId(String secretVersionId) {
        this.secretVersionId = secretVersionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="9f8400-e29b-41d4-a716-926655440034", value="The version ID of the password secret from the OPA vault.")
    @JsonProperty(value="secretVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecretVersionId() {
        return this.secretVersionId;
    }

    @JsonProperty(value="secretVersionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecretVersionId(String secretVersionId) {
        this.secretVersionId = secretVersionId;
    }

    public CredentialSyncInfo syncState(CredentialSyncState syncState) {
        this.syncState = syncState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="syncState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CredentialSyncState getSyncState() {
        return this.syncState;
    }

    @JsonProperty(value="syncState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyncState(CredentialSyncState syncState) {
        this.syncState = syncState;
    }

    @Nullable
    @ApiModelProperty(example="2024-06-10T11:30:01Z", value="Timestamp when the credential was changed")
    @JsonProperty(value="syncTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getSyncTime() {
        return this.syncTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialSyncInfo credentialSyncInfo = (CredentialSyncInfo)o;
        return Objects.equals(this.errorCode, credentialSyncInfo.errorCode) && Objects.equals(this.errorReason, credentialSyncInfo.errorReason) && Objects.equals(this.secretVersionId, credentialSyncInfo.secretVersionId) && Objects.equals((Object)this.syncState, (Object)credentialSyncInfo.syncState) && Objects.equals(this.syncTime, credentialSyncInfo.syncTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errorCode, this.errorReason, this.secretVersionId, this.syncState, this.syncTime});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CredentialSyncInfo {\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorReason: ").append(this.toIndentedString(this.errorReason)).append("\n");
        sb.append("    secretVersionId: ").append(this.toIndentedString(this.secretVersionId)).append("\n");
        sb.append("    syncState: ").append(this.toIndentedString((Object)this.syncState)).append("\n");
        sb.append("    syncTime: ").append(this.toIndentedString(this.syncTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

