/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.OAuth2RefreshToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class UserOAuthApi {
    private ApiClient apiClient;

    public UserOAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserOAuthApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OAuth2RefreshToken getRefreshTokenForUserAndClient(String userId, String clientId, String tokenId, String expand) throws ApiException {
        return this.getRefreshTokenForUserAndClient(userId, clientId, tokenId, expand, Collections.emptyMap());
    }

    public OAuth2RefreshToken getRefreshTokenForUserAndClient(String userId, String clientId, String tokenId, String expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getRefreshTokenForUserAndClient");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling getRefreshTokenForUserAndClient");
        }
        if (tokenId == null) {
            throw new ApiException(400, "Missing the required parameter 'tokenId' when calling getRefreshTokenForUserAndClient");
        }
        String localVarPath = "/api/v1/users/{userId}/clients/{clientId}/tokens/{tokenId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{tokenId\\}", this.apiClient.escapeString(tokenId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2RefreshToken> localVarReturnType = new TypeReference<OAuth2RefreshToken>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<OAuth2RefreshToken> listRefreshTokensForUserAndClient(String userId, String clientId, String expand, String after, Integer limit) throws ApiException {
        return this.listRefreshTokensForUserAndClient(userId, clientId, expand, after, limit, Collections.emptyMap());
    }

    public List<OAuth2RefreshToken> listRefreshTokensForUserAndClient(String userId, String clientId, String expand, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listRefreshTokensForUserAndClient");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling listRefreshTokensForUserAndClient");
        }
        String localVarPath = "/api/v1/users/{userId}/clients/{clientId}/tokens".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("expand", expand));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<OAuth2RefreshToken>> localVarReturnType = new TypeReference<List<OAuth2RefreshToken>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void revokeTokenForUserAndClient(String userId, String clientId, String tokenId) throws ApiException {
        this.revokeTokenForUserAndClient(userId, clientId, tokenId, Collections.emptyMap());
    }

    public void revokeTokenForUserAndClient(String userId, String clientId, String tokenId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling revokeTokenForUserAndClient");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling revokeTokenForUserAndClient");
        }
        if (tokenId == null) {
            throw new ApiException(400, "Missing the required parameter 'tokenId' when calling revokeTokenForUserAndClient");
        }
        String localVarPath = "/api/v1/users/{userId}/clients/{clientId}/tokens/{tokenId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString())).replaceAll("\\{tokenId\\}", this.apiClient.escapeString(tokenId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void revokeTokensForUserAndClient(String userId, String clientId) throws ApiException {
        this.revokeTokensForUserAndClient(userId, clientId, Collections.emptyMap());
    }

    public void revokeTokensForUserAndClient(String userId, String clientId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling revokeTokensForUserAndClient");
        }
        if (clientId == null) {
            throw new ApiException(400, "Missing the required parameter 'clientId' when calling revokeTokensForUserAndClient");
        }
        String localVarPath = "/api/v1/users/{userId}/clients/{clientId}/tokens".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{clientId\\}", this.apiClient.escapeString(clientId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

