/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.CreateResourceSetRequest;
import com.okta.sdk.resource.model.ResourceSet;
import com.okta.sdk.resource.model.ResourceSets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class RoleCResourceSetApi {
    private ApiClient apiClient;

    public RoleCResourceSetApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleCResourceSetApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ResourceSet createResourceSet(CreateResourceSetRequest instance) throws ApiException {
        return this.createResourceSet(instance, Collections.emptyMap());
    }

    public ResourceSet createResourceSet(CreateResourceSetRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        CreateResourceSetRequest localVarPostBody = instance;
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling createResourceSet");
        }
        String localVarPath = "/api/v1/iam/resource-sets";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSet> localVarReturnType = new TypeReference<ResourceSet>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteResourceSet(String resourceSetIdOrLabel) throws ApiException {
        this.deleteResourceSet(resourceSetIdOrLabel, Collections.emptyMap());
    }

    public void deleteResourceSet(String resourceSetIdOrLabel, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling deleteResourceSet");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public ResourceSet getResourceSet(String resourceSetIdOrLabel) throws ApiException {
        return this.getResourceSet(resourceSetIdOrLabel, Collections.emptyMap());
    }

    public ResourceSet getResourceSet(String resourceSetIdOrLabel, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling getResourceSet");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSet> localVarReturnType = new TypeReference<ResourceSet>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSets listResourceSets(String after) throws ApiException {
        return this.listResourceSets(after, Collections.emptyMap());
    }

    public ResourceSets listResourceSets(String after, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/iam/resource-sets";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSets> localVarReturnType = new TypeReference<ResourceSets>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ResourceSet replaceResourceSet(String resourceSetIdOrLabel, ResourceSet instance) throws ApiException {
        return this.replaceResourceSet(resourceSetIdOrLabel, instance, Collections.emptyMap());
    }

    public ResourceSet replaceResourceSet(String resourceSetIdOrLabel, ResourceSet instance, Map<String, String> additionalHeaders) throws ApiException {
        ResourceSet localVarPostBody = instance;
        if (resourceSetIdOrLabel == null) {
            throw new ApiException(400, "Missing the required parameter 'resourceSetIdOrLabel' when calling replaceResourceSet");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling replaceResourceSet");
        }
        String localVarPath = "/api/v1/iam/resource-sets/{resourceSetIdOrLabel}".replaceAll("\\{resourceSetIdOrLabel\\}", this.apiClient.escapeString(resourceSetIdOrLabel.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<ResourceSet> localVarReturnType = new TypeReference<ResourceSet>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

