/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.CatalogApplication;
import com.okta.sdk.resource.model.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class RoleBTargetAdminApi {
    private ApiClient apiClient;

    public RoleBTargetAdminApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleBTargetAdminApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void assignAllAppsAsTargetToRoleForUser(String userId, String roleAssignmentId) throws ApiException {
        this.assignAllAppsAsTargetToRoleForUser(userId, roleAssignmentId, Collections.emptyMap());
    }

    public void assignAllAppsAsTargetToRoleForUser(String userId, String roleAssignmentId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling assignAllAppsAsTargetToRoleForUser");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling assignAllAppsAsTargetToRoleForUser");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignAppInstanceTargetToAppAdminRoleForUser(String userId, String roleAssignmentId, String appName, String appId) throws ApiException {
        this.assignAppInstanceTargetToAppAdminRoleForUser(userId, roleAssignmentId, appName, appId, Collections.emptyMap());
    }

    public void assignAppInstanceTargetToAppAdminRoleForUser(String userId, String roleAssignmentId, String appName, String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling assignAppInstanceTargetToAppAdminRoleForUser");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignAppTargetToAdminRoleForUser(String userId, String roleAssignmentId, String appName) throws ApiException {
        this.assignAppTargetToAdminRoleForUser(userId, roleAssignmentId, appName, Collections.emptyMap());
    }

    public void assignAppTargetToAdminRoleForUser(String userId, String roleAssignmentId, String appName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling assignAppTargetToAdminRoleForUser");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling assignAppTargetToAdminRoleForUser");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling assignAppTargetToAdminRoleForUser");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignGroupTargetToUserRole(String userId, String roleAssignmentId, String groupId) throws ApiException {
        this.assignGroupTargetToUserRole(userId, roleAssignmentId, groupId, Collections.emptyMap());
    }

    public void assignGroupTargetToUserRole(String userId, String roleAssignmentId, String groupId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling assignGroupTargetToUserRole");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling assignGroupTargetToUserRole");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignGroupTargetToUserRole");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/groups/{groupId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForUser(String userId, String roleAssignmentId, String after, Integer limit) throws ApiException {
        return this.listApplicationTargetsForApplicationAdministratorRoleForUser(userId, roleAssignmentId, after, limit, Collections.emptyMap());
    }

    public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForUser(String userId, String roleAssignmentId, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling listApplicationTargetsForApplicationAdministratorRoleForUser");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<CatalogApplication>> localVarReturnType = new TypeReference<List<CatalogApplication>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Group> listGroupTargetsForRole(String userId, String roleAssignmentId, String after, Integer limit) throws ApiException {
        return this.listGroupTargetsForRole(userId, roleAssignmentId, after, limit, Collections.emptyMap());
    }

    public List<Group> listGroupTargetsForRole(String userId, String roleAssignmentId, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listGroupTargetsForRole");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling listGroupTargetsForRole");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/groups".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Group>> localVarReturnType = new TypeReference<List<Group>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void unassignAppInstanceTargetFromAdminRoleForUser(String userId, String roleAssignmentId, String appName, String appId) throws ApiException {
        this.unassignAppInstanceTargetFromAdminRoleForUser(userId, roleAssignmentId, appName, appId, Collections.emptyMap());
    }

    public void unassignAppInstanceTargetFromAdminRoleForUser(String userId, String roleAssignmentId, String appName, String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling unassignAppInstanceTargetFromAdminRoleForUser");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unassignAppTargetFromAppAdminRoleForUser(String userId, String roleAssignmentId, String appName) throws ApiException {
        this.unassignAppTargetFromAppAdminRoleForUser(userId, roleAssignmentId, appName, Collections.emptyMap());
    }

    public void unassignAppTargetFromAppAdminRoleForUser(String userId, String roleAssignmentId, String appName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unassignAppTargetFromAppAdminRoleForUser");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling unassignAppTargetFromAppAdminRoleForUser");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling unassignAppTargetFromAppAdminRoleForUser");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unassignGroupTargetFromUserAdminRole(String userId, String roleAssignmentId, String groupId) throws ApiException {
        this.unassignGroupTargetFromUserAdminRole(userId, roleAssignmentId, groupId, Collections.emptyMap());
    }

    public void unassignGroupTargetFromUserAdminRole(String userId, String roleAssignmentId, String groupId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling unassignGroupTargetFromUserAdminRole");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling unassignGroupTargetFromUserAdminRole");
        }
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling unassignGroupTargetFromUserAdminRole");
        }
        String localVarPath = "/api/v1/users/{userId}/roles/{roleAssignmentId}/targets/groups/{groupId}".replaceAll("\\{userId\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

