/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.LogStream;
import com.okta.sdk.resource.model.LogStreamPutSchema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class LogStreamApi {
    private ApiClient apiClient;

    public LogStreamApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogStreamApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public LogStream activateLogStream(String logStreamId) throws ApiException {
        return this.activateLogStream(logStreamId, Collections.emptyMap());
    }

    public LogStream activateLogStream(String logStreamId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (logStreamId == null) {
            throw new ApiException(400, "Missing the required parameter 'logStreamId' when calling activateLogStream");
        }
        String localVarPath = "/api/v1/logStreams/{logStreamId}/lifecycle/activate".replaceAll("\\{logStreamId\\}", this.apiClient.escapeString(logStreamId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<LogStream> localVarReturnType = new TypeReference<LogStream>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LogStream createLogStream(LogStream instance) throws ApiException {
        return this.createLogStream(instance, Collections.emptyMap());
    }

    public LogStream createLogStream(LogStream instance, Map<String, String> additionalHeaders) throws ApiException {
        LogStream localVarPostBody = instance;
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling createLogStream");
        }
        String localVarPath = "/api/v1/logStreams";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<LogStream> localVarReturnType = new TypeReference<LogStream>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LogStream deactivateLogStream(String logStreamId) throws ApiException {
        return this.deactivateLogStream(logStreamId, Collections.emptyMap());
    }

    public LogStream deactivateLogStream(String logStreamId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (logStreamId == null) {
            throw new ApiException(400, "Missing the required parameter 'logStreamId' when calling deactivateLogStream");
        }
        String localVarPath = "/api/v1/logStreams/{logStreamId}/lifecycle/deactivate".replaceAll("\\{logStreamId\\}", this.apiClient.escapeString(logStreamId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<LogStream> localVarReturnType = new TypeReference<LogStream>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteLogStream(String logStreamId) throws ApiException {
        this.deleteLogStream(logStreamId, Collections.emptyMap());
    }

    public void deleteLogStream(String logStreamId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (logStreamId == null) {
            throw new ApiException(400, "Missing the required parameter 'logStreamId' when calling deleteLogStream");
        }
        String localVarPath = "/api/v1/logStreams/{logStreamId}".replaceAll("\\{logStreamId\\}", this.apiClient.escapeString(logStreamId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public LogStream getLogStream(String logStreamId) throws ApiException {
        return this.getLogStream(logStreamId, Collections.emptyMap());
    }

    public LogStream getLogStream(String logStreamId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (logStreamId == null) {
            throw new ApiException(400, "Missing the required parameter 'logStreamId' when calling getLogStream");
        }
        String localVarPath = "/api/v1/logStreams/{logStreamId}".replaceAll("\\{logStreamId\\}", this.apiClient.escapeString(logStreamId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<LogStream> localVarReturnType = new TypeReference<LogStream>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<LogStream> listLogStreams(String after, Integer limit, String filter) throws ApiException {
        return this.listLogStreams(after, limit, filter, Collections.emptyMap());
    }

    public List<LogStream> listLogStreams(String after, Integer limit, String filter, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/logStreams";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<LogStream>> localVarReturnType = new TypeReference<List<LogStream>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public LogStream replaceLogStream(String logStreamId, LogStreamPutSchema instance) throws ApiException {
        return this.replaceLogStream(logStreamId, instance, Collections.emptyMap());
    }

    public LogStream replaceLogStream(String logStreamId, LogStreamPutSchema instance, Map<String, String> additionalHeaders) throws ApiException {
        LogStreamPutSchema localVarPostBody = instance;
        if (logStreamId == null) {
            throw new ApiException(400, "Missing the required parameter 'logStreamId' when calling replaceLogStream");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling replaceLogStream");
        }
        String localVarPath = "/api/v1/logStreams/{logStreamId}".replaceAll("\\{logStreamId\\}", this.apiClient.escapeString(logStreamId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<LogStream> localVarReturnType = new TypeReference<LogStream>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

