/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.LinkedObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class LinkedObjectApi {
    private ApiClient apiClient;

    public LinkedObjectApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LinkedObjectApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public LinkedObject createLinkedObjectDefinition(LinkedObject linkedObject) throws ApiException {
        return this.createLinkedObjectDefinition(linkedObject, Collections.emptyMap());
    }

    public LinkedObject createLinkedObjectDefinition(LinkedObject linkedObject, Map<String, String> additionalHeaders) throws ApiException {
        LinkedObject localVarPostBody = linkedObject;
        if (linkedObject == null) {
            throw new ApiException(400, "Missing the required parameter 'linkedObject' when calling createLinkedObjectDefinition");
        }
        String localVarPath = "/api/v1/meta/schemas/user/linkedObjects";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<LinkedObject> localVarReturnType = new TypeReference<LinkedObject>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteLinkedObjectDefinition(String linkedObjectName) throws ApiException {
        this.deleteLinkedObjectDefinition(linkedObjectName, Collections.emptyMap());
    }

    public void deleteLinkedObjectDefinition(String linkedObjectName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (linkedObjectName == null) {
            throw new ApiException(400, "Missing the required parameter 'linkedObjectName' when calling deleteLinkedObjectDefinition");
        }
        String localVarPath = "/api/v1/meta/schemas/user/linkedObjects/{linkedObjectName}".replaceAll("\\{linkedObjectName\\}", this.apiClient.escapeString(linkedObjectName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public LinkedObject getLinkedObjectDefinition(String linkedObjectName) throws ApiException {
        return this.getLinkedObjectDefinition(linkedObjectName, Collections.emptyMap());
    }

    public LinkedObject getLinkedObjectDefinition(String linkedObjectName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (linkedObjectName == null) {
            throw new ApiException(400, "Missing the required parameter 'linkedObjectName' when calling getLinkedObjectDefinition");
        }
        String localVarPath = "/api/v1/meta/schemas/user/linkedObjects/{linkedObjectName}".replaceAll("\\{linkedObjectName\\}", this.apiClient.escapeString(linkedObjectName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<LinkedObject> localVarReturnType = new TypeReference<LinkedObject>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<LinkedObject> listLinkedObjectDefinitions() throws ApiException {
        return this.listLinkedObjectDefinitions(Collections.emptyMap());
    }

    public List<LinkedObject> listLinkedObjectDefinitions(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/meta/schemas/user/linkedObjects";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<LinkedObject>> localVarReturnType = new TypeReference<List<LinkedObject>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

