/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.EmailCustomization;
import com.okta.sdk.resource.model.EmailDefaultContent;
import com.okta.sdk.resource.model.EmailPreview;
import com.okta.sdk.resource.model.EmailSettings;
import com.okta.sdk.resource.model.EmailSettingsResponse;
import com.okta.sdk.resource.model.EmailTemplateResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class CustomTemplatesApi {
    private ApiClient apiClient;

    public CustomTemplatesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomTemplatesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public EmailCustomization createEmailCustomization(String brandId, String templateName, EmailCustomization instance) throws ApiException {
        return this.createEmailCustomization(brandId, templateName, instance, Collections.emptyMap());
    }

    public EmailCustomization createEmailCustomization(String brandId, String templateName, EmailCustomization instance, Map<String, String> additionalHeaders) throws ApiException {
        EmailCustomization localVarPostBody = instance;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling createEmailCustomization");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling createEmailCustomization");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailCustomization> localVarReturnType = new TypeReference<EmailCustomization>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteAllCustomizations(String brandId, String templateName) throws ApiException {
        this.deleteAllCustomizations(brandId, templateName, Collections.emptyMap());
    }

    public void deleteAllCustomizations(String brandId, String templateName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteAllCustomizations");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling deleteAllCustomizations");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void deleteEmailCustomization(String brandId, String templateName, String customizationId) throws ApiException {
        this.deleteEmailCustomization(brandId, templateName, customizationId, Collections.emptyMap());
    }

    public void deleteEmailCustomization(String brandId, String templateName, String customizationId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteEmailCustomization");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling deleteEmailCustomization");
        }
        if (customizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'customizationId' when calling deleteEmailCustomization");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString())).replaceAll("\\{customizationId\\}", this.apiClient.escapeString(customizationId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public EmailPreview getCustomizationPreview(String brandId, String templateName, String customizationId) throws ApiException {
        return this.getCustomizationPreview(brandId, templateName, customizationId, Collections.emptyMap());
    }

    public EmailPreview getCustomizationPreview(String brandId, String templateName, String customizationId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getCustomizationPreview");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling getCustomizationPreview");
        }
        if (customizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'customizationId' when calling getCustomizationPreview");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}/preview".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString())).replaceAll("\\{customizationId\\}", this.apiClient.escapeString(customizationId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailPreview> localVarReturnType = new TypeReference<EmailPreview>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailCustomization getEmailCustomization(String brandId, String templateName, String customizationId) throws ApiException {
        return this.getEmailCustomization(brandId, templateName, customizationId, Collections.emptyMap());
    }

    public EmailCustomization getEmailCustomization(String brandId, String templateName, String customizationId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getEmailCustomization");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling getEmailCustomization");
        }
        if (customizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'customizationId' when calling getEmailCustomization");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString())).replaceAll("\\{customizationId\\}", this.apiClient.escapeString(customizationId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailCustomization> localVarReturnType = new TypeReference<EmailCustomization>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailDefaultContent getEmailDefaultContent(String brandId, String templateName, String language) throws ApiException {
        return this.getEmailDefaultContent(brandId, templateName, language, Collections.emptyMap());
    }

    public EmailDefaultContent getEmailDefaultContent(String brandId, String templateName, String language, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getEmailDefaultContent");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling getEmailDefaultContent");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/default-content".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("language", language));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailDefaultContent> localVarReturnType = new TypeReference<EmailDefaultContent>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailPreview getEmailDefaultPreview(String brandId, String templateName, String language) throws ApiException {
        return this.getEmailDefaultPreview(brandId, templateName, language, Collections.emptyMap());
    }

    public EmailPreview getEmailDefaultPreview(String brandId, String templateName, String language, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getEmailDefaultPreview");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling getEmailDefaultPreview");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/default-content/preview".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("language", language));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailPreview> localVarReturnType = new TypeReference<EmailPreview>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailSettingsResponse getEmailSettings(String brandId, String templateName) throws ApiException {
        return this.getEmailSettings(brandId, templateName, Collections.emptyMap());
    }

    public EmailSettingsResponse getEmailSettings(String brandId, String templateName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getEmailSettings");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling getEmailSettings");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/settings".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailSettingsResponse> localVarReturnType = new TypeReference<EmailSettingsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailTemplateResponse getEmailTemplate(String brandId, String templateName, List<String> expand) throws ApiException {
        return this.getEmailTemplate(brandId, templateName, expand, Collections.emptyMap());
    }

    public EmailTemplateResponse getEmailTemplate(String brandId, String templateName, List<String> expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getEmailTemplate");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling getEmailTemplate");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailTemplateResponse> localVarReturnType = new TypeReference<EmailTemplateResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<EmailCustomization> listEmailCustomizations(String brandId, String templateName, String after, Integer limit) throws ApiException {
        return this.listEmailCustomizations(brandId, templateName, after, limit, Collections.emptyMap());
    }

    public List<EmailCustomization> listEmailCustomizations(String brandId, String templateName, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling listEmailCustomizations");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling listEmailCustomizations");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<EmailCustomization>> localVarReturnType = new TypeReference<List<EmailCustomization>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<EmailTemplateResponse> listEmailTemplates(String brandId, String after, Integer limit, List<String> expand) throws ApiException {
        return this.listEmailTemplates(brandId, after, limit, expand, Collections.emptyMap());
    }

    public List<EmailTemplateResponse> listEmailTemplates(String brandId, String after, Integer limit, List<String> expand, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling listEmailTemplates");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "expand", expand));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<EmailTemplateResponse>> localVarReturnType = new TypeReference<List<EmailTemplateResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailCustomization replaceEmailCustomization(String brandId, String templateName, String customizationId, EmailCustomization instance) throws ApiException {
        return this.replaceEmailCustomization(brandId, templateName, customizationId, instance, Collections.emptyMap());
    }

    public EmailCustomization replaceEmailCustomization(String brandId, String templateName, String customizationId, EmailCustomization instance, Map<String, String> additionalHeaders) throws ApiException {
        EmailCustomization localVarPostBody = instance;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replaceEmailCustomization");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling replaceEmailCustomization");
        }
        if (customizationId == null) {
            throw new ApiException(400, "Missing the required parameter 'customizationId' when calling replaceEmailCustomization");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/customizations/{customizationId}".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString())).replaceAll("\\{customizationId\\}", this.apiClient.escapeString(customizationId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailCustomization> localVarReturnType = new TypeReference<EmailCustomization>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public EmailSettings replaceEmailSettings(String brandId, String templateName, EmailSettings emailSettings) throws ApiException {
        return this.replaceEmailSettings(brandId, templateName, emailSettings, Collections.emptyMap());
    }

    public EmailSettings replaceEmailSettings(String brandId, String templateName, EmailSettings emailSettings, Map<String, String> additionalHeaders) throws ApiException {
        EmailSettings localVarPostBody = emailSettings;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replaceEmailSettings");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling replaceEmailSettings");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/settings".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml", "application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<EmailSettings> localVarReturnType = new TypeReference<EmailSettings>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void sendTestEmail(String brandId, String templateName, String language) throws ApiException {
        this.sendTestEmail(brandId, templateName, language, Collections.emptyMap());
    }

    public void sendTestEmail(String brandId, String templateName, String language, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling sendTestEmail");
        }
        if (templateName == null) {
            throw new ApiException(400, "Missing the required parameter 'templateName' when calling sendTestEmail");
        }
        String localVarPath = "/api/v1/brands/{brandId}/templates/email/{templateName}/test".replaceAll("\\{brandId\\}", this.apiClient.escapeString(brandId.toString())).replaceAll("\\{templateName\\}", this.apiClient.escapeString(templateName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("language", language));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

