/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class ApplicationSsoApi {
    private ApiClient apiClient;

    public ApplicationSsoApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApplicationSsoApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public String previewSAMLmetadataForApplication(String appId, String kid) throws ApiException {
        return this.previewSAMLmetadataForApplication(appId, kid, Collections.emptyMap());
    }

    public String previewSAMLmetadataForApplication(String appId, String kid, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling previewSAMLmetadataForApplication");
        }
        if (kid == null) {
            throw new ApiException(400, "Missing the required parameter 'kid' when calling previewSAMLmetadataForApplication");
        }
        String localVarPath = "/api/v1/apps/{appId}/sso/saml/metadata".replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("kid", kid));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"text/xml", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts, localVarPath);
        String[] localVarContentTypes = new String[]{"text/xml"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<String> localVarReturnType = new TypeReference<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

