/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.SecurityEventsProviderRequest;
import com.okta.sdk.resource.model.SecurityEventsProviderResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class SsfReceiverApi {
    private ApiClient apiClient;

    public SsfReceiverApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SsfReceiverApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public SecurityEventsProviderResponse activateSecurityEventsProviderInstance(String securityEventProviderId) throws ApiException {
        return this.activateSecurityEventsProviderInstance(securityEventProviderId, Collections.emptyMap());
    }

    public SecurityEventsProviderResponse activateSecurityEventsProviderInstance(String securityEventProviderId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (securityEventProviderId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityEventProviderId' when calling activateSecurityEventsProviderInstance");
        }
        String localVarPath = "/api/v1/security-events-providers/{securityEventProviderId}/lifecycle/activate".replaceAll("\\{securityEventProviderId\\}", this.apiClient.escapeString(securityEventProviderId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<SecurityEventsProviderResponse> localVarReturnType = new TypeReference<SecurityEventsProviderResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SecurityEventsProviderResponse createSecurityEventsProviderInstance(SecurityEventsProviderRequest instance) throws ApiException {
        return this.createSecurityEventsProviderInstance(instance, Collections.emptyMap());
    }

    public SecurityEventsProviderResponse createSecurityEventsProviderInstance(SecurityEventsProviderRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        SecurityEventsProviderRequest localVarPostBody = instance;
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling createSecurityEventsProviderInstance");
        }
        String localVarPath = "/api/v1/security-events-providers";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<SecurityEventsProviderResponse> localVarReturnType = new TypeReference<SecurityEventsProviderResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SecurityEventsProviderResponse deactivateSecurityEventsProviderInstance(String securityEventProviderId) throws ApiException {
        return this.deactivateSecurityEventsProviderInstance(securityEventProviderId, Collections.emptyMap());
    }

    public SecurityEventsProviderResponse deactivateSecurityEventsProviderInstance(String securityEventProviderId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (securityEventProviderId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityEventProviderId' when calling deactivateSecurityEventsProviderInstance");
        }
        String localVarPath = "/api/v1/security-events-providers/{securityEventProviderId}/lifecycle/deactivate".replaceAll("\\{securityEventProviderId\\}", this.apiClient.escapeString(securityEventProviderId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<SecurityEventsProviderResponse> localVarReturnType = new TypeReference<SecurityEventsProviderResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteSecurityEventsProviderInstance(String securityEventProviderId) throws ApiException {
        this.deleteSecurityEventsProviderInstance(securityEventProviderId, Collections.emptyMap());
    }

    public void deleteSecurityEventsProviderInstance(String securityEventProviderId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (securityEventProviderId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityEventProviderId' when calling deleteSecurityEventsProviderInstance");
        }
        String localVarPath = "/api/v1/security-events-providers/{securityEventProviderId}".replaceAll("\\{securityEventProviderId\\}", this.apiClient.escapeString(securityEventProviderId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public SecurityEventsProviderResponse getSecurityEventsProviderInstance(String securityEventProviderId) throws ApiException {
        return this.getSecurityEventsProviderInstance(securityEventProviderId, Collections.emptyMap());
    }

    public SecurityEventsProviderResponse getSecurityEventsProviderInstance(String securityEventProviderId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (securityEventProviderId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityEventProviderId' when calling getSecurityEventsProviderInstance");
        }
        String localVarPath = "/api/v1/security-events-providers/{securityEventProviderId}".replaceAll("\\{securityEventProviderId\\}", this.apiClient.escapeString(securityEventProviderId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<SecurityEventsProviderResponse> localVarReturnType = new TypeReference<SecurityEventsProviderResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<SecurityEventsProviderResponse> listSecurityEventsProviderInstances() throws ApiException {
        return this.listSecurityEventsProviderInstances(Collections.emptyMap());
    }

    public List<SecurityEventsProviderResponse> listSecurityEventsProviderInstances(Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/security-events-providers";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<SecurityEventsProviderResponse>> localVarReturnType = new TypeReference<List<SecurityEventsProviderResponse>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public SecurityEventsProviderResponse replaceSecurityEventsProviderInstance(String securityEventProviderId, SecurityEventsProviderRequest instance) throws ApiException {
        return this.replaceSecurityEventsProviderInstance(securityEventProviderId, instance, Collections.emptyMap());
    }

    public SecurityEventsProviderResponse replaceSecurityEventsProviderInstance(String securityEventProviderId, SecurityEventsProviderRequest instance, Map<String, String> additionalHeaders) throws ApiException {
        SecurityEventsProviderRequest localVarPostBody = instance;
        if (securityEventProviderId == null) {
            throw new ApiException(400, "Missing the required parameter 'securityEventProviderId' when calling replaceSecurityEventsProviderInstance");
        }
        if (instance == null) {
            throw new ApiException(400, "Missing the required parameter 'instance' when calling replaceSecurityEventsProviderInstance");
        }
        String localVarPath = "/api/v1/security-events-providers/{securityEventProviderId}".replaceAll("\\{securityEventProviderId\\}", this.apiClient.escapeString(securityEventProviderId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<SecurityEventsProviderResponse> localVarReturnType = new TypeReference<SecurityEventsProviderResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

