/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TokenType {
    URN_IETF_PARAMS_OAUTH_TOKEN_TYPE_ACCESS_TOKEN("urn:ietf:params:oauth:token-type:access_token"),
    URN_IETF_PARAMS_OAUTH_TOKEN_TYPE_ID_TOKEN("urn:ietf:params:oauth:token-type:id_token"),
    URN_IETF_PARAMS_OAUTH_TOKEN_TYPE_JWT("urn:ietf:params:oauth:token-type:jwt"),
    URN_IETF_PARAMS_OAUTH_TOKEN_TYPE_REFRESH_TOKEN("urn:ietf:params:oauth:token-type:refresh_token"),
    URN_IETF_PARAMS_OAUTH_TOKEN_TYPE_SAML1("urn:ietf:params:oauth:token-type:saml1"),
    URN_IETF_PARAMS_OAUTH_TOKEN_TYPE_SAML2("urn:ietf:params:oauth:token-type:saml2"),
    URN_OKTA_OAUTH_TOKEN_TYPE_WEB_SSO_TOKEN("urn:okta:oauth:token-type:web_sso_token"),
    URN_X_OATH_PARAMS_OAUTH_TOKEN_TYPE_DEVICE_SECRET("urn:x-oath:params:oauth:token-type:device-secret"),
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    private TokenType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static TokenType fromValue(String value) {
        for (TokenType b : TokenType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString().toString());
    }
}

