/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains SAML 1.1 sign-on mode attributes")
@JsonPropertyOrder(value={"audienceOverride", "defaultRelayState", "recipientOverride", "ssoAcsUrlOverride"})
public class OINSaml11ApplicationSettingsSignOn
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUDIENCE_OVERRIDE = "audienceOverride";
    private String audienceOverride;
    public static final String JSON_PROPERTY_DEFAULT_RELAY_STATE = "defaultRelayState";
    private String defaultRelayState;
    public static final String JSON_PROPERTY_RECIPIENT_OVERRIDE = "recipientOverride";
    private String recipientOverride;
    public static final String JSON_PROPERTY_SSO_ACS_URL_OVERRIDE = "ssoAcsUrlOverride";
    private String ssoAcsUrlOverride;

    public OINSaml11ApplicationSettingsSignOn audienceOverride(String audienceOverride) {
        this.audienceOverride = audienceOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Audience override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(value="audienceOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAudienceOverride() {
        return this.audienceOverride;
    }

    @JsonProperty(value="audienceOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAudienceOverride(String audienceOverride) {
        this.audienceOverride = audienceOverride;
    }

    public OINSaml11ApplicationSettingsSignOn defaultRelayState(String defaultRelayState) {
        this.defaultRelayState = defaultRelayState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifies a specific application resource in an IdP-initiated SSO scenario")
    @JsonProperty(value="defaultRelayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultRelayState() {
        return this.defaultRelayState;
    }

    @JsonProperty(value="defaultRelayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultRelayState(String defaultRelayState) {
        this.defaultRelayState = defaultRelayState;
    }

    public OINSaml11ApplicationSettingsSignOn recipientOverride(String recipientOverride) {
        this.recipientOverride = recipientOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Recipient override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(value="recipientOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecipientOverride() {
        return this.recipientOverride;
    }

    @JsonProperty(value="recipientOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecipientOverride(String recipientOverride) {
        this.recipientOverride = recipientOverride;
    }

    public OINSaml11ApplicationSettingsSignOn ssoAcsUrlOverride(String ssoAcsUrlOverride) {
        this.ssoAcsUrlOverride = ssoAcsUrlOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Assertion Consumer Service (ACS) URL override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(value="ssoAcsUrlOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSsoAcsUrlOverride() {
        return this.ssoAcsUrlOverride;
    }

    @JsonProperty(value="ssoAcsUrlOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSsoAcsUrlOverride(String ssoAcsUrlOverride) {
        this.ssoAcsUrlOverride = ssoAcsUrlOverride;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OINSaml11ApplicationSettingsSignOn oiNSaml11ApplicationSettingsSignOn = (OINSaml11ApplicationSettingsSignOn)o;
        return Objects.equals(this.audienceOverride, oiNSaml11ApplicationSettingsSignOn.audienceOverride) && Objects.equals(this.defaultRelayState, oiNSaml11ApplicationSettingsSignOn.defaultRelayState) && Objects.equals(this.recipientOverride, oiNSaml11ApplicationSettingsSignOn.recipientOverride) && Objects.equals(this.ssoAcsUrlOverride, oiNSaml11ApplicationSettingsSignOn.ssoAcsUrlOverride);
    }

    public int hashCode() {
        return Objects.hash(this.audienceOverride, this.defaultRelayState, this.recipientOverride, this.ssoAcsUrlOverride);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OINSaml11ApplicationSettingsSignOn {\n");
        sb.append("    audienceOverride: ").append(this.toIndentedString(this.audienceOverride)).append("\n");
        sb.append("    defaultRelayState: ").append(this.toIndentedString(this.defaultRelayState)).append("\n");
        sb.append("    recipientOverride: ").append(this.toIndentedString(this.recipientOverride)).append("\n");
        sb.append("    ssoAcsUrlOverride: ").append(this.toIndentedString(this.ssoAcsUrlOverride)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

