/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="The `id` property in the response as `id` serves as the unique ID for the key, which you can specify when invoking other CRUD operations.   The `keyId` provided in the response is the alias of the public key that you can use to get details of the public key data in a separate call.")
@JsonPropertyOrder(value={"created", "id", "isUsed", "keyId", "lastUpdated", "name"})
public class HookKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private JsonNullable<OffsetDateTime> created = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_IS_USED = "isUsed";
    private Boolean isUsed;
    public static final String JSON_PROPERTY_KEY_ID = "keyId";
    private String keyId;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private JsonNullable<OffsetDateTime> lastUpdated = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    @Nullable
    @ApiModelProperty(value="Timestamp when the key was created")
    @JsonIgnore
    public OffsetDateTime getCreated() {
        if (this.created == null) {
            this.created = JsonNullable.undefined();
        }
        return (OffsetDateTime)this.created.orElse(null);
    }

    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getCreated_JsonNullable() {
        return this.created;
    }

    @JsonProperty(value="created")
    private void setCreated_JsonNullable(JsonNullable<OffsetDateTime> created) {
        this.created = created;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the key")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(value="Whether this key is currently in use by other applications")
    @JsonProperty(value="isUsed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsUsed() {
        return this.isUsed;
    }

    @Nullable
    @ApiModelProperty(value="The alias of the public key")
    @JsonProperty(value="keyId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKeyId() {
        return this.keyId;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the key was updated")
    @JsonIgnore
    public OffsetDateTime getLastUpdated() {
        if (this.lastUpdated == null) {
            this.lastUpdated = JsonNullable.undefined();
        }
        return (OffsetDateTime)this.lastUpdated.orElse(null);
    }

    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getLastUpdated_JsonNullable() {
        return this.lastUpdated;
    }

    @JsonProperty(value="lastUpdated")
    private void setLastUpdated_JsonNullable(JsonNullable<OffsetDateTime> lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public HookKey name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Display name of the key")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HookKey hookKey = (HookKey)o;
        return HookKey.equalsNullable(this.created, hookKey.created) && Objects.equals(this.id, hookKey.id) && Objects.equals(this.isUsed, hookKey.isUsed) && Objects.equals(this.keyId, hookKey.keyId) && HookKey.equalsNullable(this.lastUpdated, hookKey.lastUpdated) && Objects.equals(this.name, hookKey.name);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(HookKey.hashCodeNullable(this.created), this.id, this.isUsed, this.keyId, HookKey.hashCodeNullable(this.lastUpdated), this.name);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HookKey {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    isUsed: ").append(this.toIndentedString(this.isUsed)).append("\n");
        sb.append("    keyId: ").append(this.toIndentedString(this.keyId)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

