package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * User verification setting. Possible values &#x60;DISCOURAGED&#x60; (the authenticator isn&#39;t asked to perform user
 * verification, but may do so at its discretion), &#x60;PREFERRED&#x60; (the client uses an authenticator capable of
 * user verification if possible), or &#x60;REQUIRED&#x60;(the client uses only an authenticator capable of user
 * verification)
 */
public enum UserVerificationEnum {

    DISCOURAGED("DISCOURAGED"),

    PREFERRED("PREFERRED"),

    REQUIRED("REQUIRED"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    UserVerificationEnum(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static UserVerificationEnum fromValue(String value) {
        for (UserVerificationEnum b : UserVerificationEnum.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
