package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The object that specifies the default action Okta is set to take
 */
@ApiModel(description = "The object that specifies the default action Okta is set to take")
@JsonPropertyOrder({ UserImportRequestDataAction.JSON_PROPERTY_RESULT })
@JsonTypeName("UserImportRequestData_action")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class UserImportRequestDataAction implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * The current default action that results when Okta imports a user. The two possible values are
     * &#x60;CREATE_USER&#x60; and &#x60;LINK_USER&#x60;. You can change the action that is taken by means of the
     * commands object you return.
     */
    public enum ResultEnum {
        CREATE_USER(String.valueOf("CREATE_USER")),

        LINK_USER(String.valueOf("LINK_USER")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        ResultEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static ResultEnum fromValue(String value) {
            for (ResultEnum b : ResultEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_RESULT = "result";
    private ResultEnum result;

    public UserImportRequestDataAction() {
    }

    public UserImportRequestDataAction result(ResultEnum result) {

        this.result = result;
        return this;
    }

    /**
     * The current default action that results when Okta imports a user. The two possible values are
     * &#x60;CREATE_USER&#x60; and &#x60;LINK_USER&#x60;. You can change the action that is taken by means of the
     * commands object you return.
     *
     * @return result
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The current default action that results when Okta imports a user. The two possible values are `CREATE_USER` and `LINK_USER`. You  can change the action that is taken by means of the commands object you return.")
    @JsonProperty(JSON_PROPERTY_RESULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ResultEnum getResult() {
        return result;
    }

    @JsonProperty(JSON_PROPERTY_RESULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResult(ResultEnum result) {
        this.result = result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserImportRequestDataAction userImportRequestDataAction = (UserImportRequestDataAction) o;
        return Objects.equals(this.result, userImportRequestDataAction.result);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(result);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserImportRequestDataAction {\n");
        sb.append("    result: ").append(toIndentedString(result)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
