package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorPushTransaction
 */
@JsonPropertyOrder({ UserFactorPushTransaction.JSON_PROPERTY_FACTOR_RESULT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "factorResult", visible = true, defaultImpl = UserFactorPushTransaction.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = UserFactorPushTransactionRejected.class, name = "REJECTED"),
        @JsonSubTypes.Type(value = UserFactorPushTransaction.class, name = "SUCCESS"),
        @JsonSubTypes.Type(value = UserFactorPushTransactionTimeout.class, name = "TIMEOUT"),
        @JsonSubTypes.Type(value = UserFactorPushTransactionWaiting.class, name = "WAITING"), })

public class UserFactorPushTransaction implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Result of the verification transaction
     */
    public enum FactorResultEnum {
        WAITING(String.valueOf("WAITING")),

        SUCCESS(String.valueOf("SUCCESS")),

        REJECTED(String.valueOf("REJECTED")),

        TIMEOUT(String.valueOf("TIMEOUT")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        FactorResultEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static FactorResultEnum fromValue(String value) {
            for (FactorResultEnum b : FactorResultEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_FACTOR_RESULT = "factorResult";
    protected FactorResultEnum factorResult;

    public UserFactorPushTransaction() {
    }

    public UserFactorPushTransaction factorResult(FactorResultEnum factorResult) {

        this.factorResult = factorResult;
        return this;
    }

    /**
     * Result of the verification transaction
     *
     * @return factorResult
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Result of the verification transaction")
    @JsonProperty(JSON_PROPERTY_FACTOR_RESULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public FactorResultEnum getFactorResult() {
        return factorResult;
    }

    @JsonProperty(JSON_PROPERTY_FACTOR_RESULT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFactorResult(FactorResultEnum factorResult) {
        this.factorResult = factorResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorPushTransaction userFactorPushTransaction = (UserFactorPushTransaction) o;
        return Objects.equals(this.factorResult, userFactorPushTransaction.factorResult);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(factorResult);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorPushTransaction {\n");
        sb.append("    factorResult: ").append(toIndentedString(factorResult)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
