package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * User profile specifies information about the Okta user
 */
@ApiModel(description = "User profile specifies information about the Okta user")
@JsonPropertyOrder({ TelephonyRequestDataUserProfile.JSON_PROPERTY_FIRST_NAME,
        TelephonyRequestDataUserProfile.JSON_PROPERTY_LAST_NAME, TelephonyRequestDataUserProfile.JSON_PROPERTY_LOGIN,
        TelephonyRequestDataUserProfile.JSON_PROPERTY_USER_ID })
@JsonTypeName("TelephonyRequestData_userProfile")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class TelephonyRequestDataUserProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;

    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;

    public static final String JSON_PROPERTY_LOGIN = "login";
    private String login;

    public static final String JSON_PROPERTY_USER_ID = "userId";
    private String userId;

    public TelephonyRequestDataUserProfile() {
    }

    public TelephonyRequestDataUserProfile firstName(String firstName) {

        this.firstName = firstName;
        return this;
    }

    /**
     * The user&#39;s first name
     *
     * @return firstName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The user's first name")
    @JsonProperty(JSON_PROPERTY_FIRST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getFirstName() {
        return firstName;
    }

    @JsonProperty(JSON_PROPERTY_FIRST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public TelephonyRequestDataUserProfile lastName(String lastName) {

        this.lastName = lastName;
        return this;
    }

    /**
     * The user&#39;s last name
     *
     * @return lastName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The user's last name")
    @JsonProperty(JSON_PROPERTY_LAST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLastName() {
        return lastName;
    }

    @JsonProperty(JSON_PROPERTY_LAST_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public TelephonyRequestDataUserProfile login(String login) {

        this.login = login;
        return this;
    }

    /**
     * The user&#39;s Okta login
     *
     * @return login
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The user's Okta login")
    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLogin() {
        return login;
    }

    @JsonProperty(JSON_PROPERTY_LOGIN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLogin(String login) {
        this.login = login;
    }

    public TelephonyRequestDataUserProfile userId(String userId) {

        this.userId = userId;
        return this;
    }

    /**
     * The user&#39;s Okta user ID
     *
     * @return userId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The user's Okta user ID")
    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getUserId() {
        return userId;
    }

    @JsonProperty(JSON_PROPERTY_USER_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TelephonyRequestDataUserProfile telephonyRequestDataUserProfile = (TelephonyRequestDataUserProfile) o;
        return Objects.equals(this.firstName, telephonyRequestDataUserProfile.firstName)
                && Objects.equals(this.lastName, telephonyRequestDataUserProfile.lastName)
                && Objects.equals(this.login, telephonyRequestDataUserProfile.login)
                && Objects.equals(this.userId, telephonyRequestDataUserProfile.userId);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(firstName, lastName, login, userId);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelephonyRequestDataUserProfile {\n");
        sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
        sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
        sb.append("    login: ").append(toIndentedString(login)).append("\n");
        sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
