package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SimulateResultConditions;
import com.okta.sdk.resource.model.SimulateResultRules;
import com.okta.sdk.resource.model.SimulateResultStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SimulateResultPoliciesItems
 */
@JsonPropertyOrder({ SimulateResultPoliciesItems.JSON_PROPERTY_CONDITIONS, SimulateResultPoliciesItems.JSON_PROPERTY_ID,
        SimulateResultPoliciesItems.JSON_PROPERTY_NAME, SimulateResultPoliciesItems.JSON_PROPERTY_RULES,
        SimulateResultPoliciesItems.JSON_PROPERTY_STATUS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SimulateResultPoliciesItems implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private List<SimulateResultConditions> conditions = null;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_RULES = "rules";
    private List<SimulateResultRules> rules = null;

    public static final String JSON_PROPERTY_STATUS = "status";
    private SimulateResultStatus status;

    public SimulateResultPoliciesItems() {
    }

    public SimulateResultPoliciesItems conditions(List<SimulateResultConditions> conditions) {

        this.conditions = conditions;
        return this;
    }

    public SimulateResultPoliciesItems addconditionsItem(SimulateResultConditions conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    /**
     * List of all conditions involved for this policy evaluation
     *
     * @return conditions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "List of all conditions involved for this policy evaluation")
    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<SimulateResultConditions> getConditions() {
        return conditions;
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(List<SimulateResultConditions> conditions) {
        this.conditions = conditions;
    }

    public SimulateResultPoliciesItems id(String id) {

        this.id = id;
        return this;
    }

    /**
     * ID of the specified policy type
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ID of the specified policy type")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public SimulateResultPoliciesItems name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Policy name
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Policy name")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public SimulateResultPoliciesItems rules(List<SimulateResultRules> rules) {

        this.rules = rules;
        return this;
    }

    public SimulateResultPoliciesItems addrulesItem(SimulateResultRules rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    /**
     * Get rules
     *
     * @return rules
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RULES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<SimulateResultRules> getRules() {
        return rules;
    }

    @JsonProperty(JSON_PROPERTY_RULES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRules(List<SimulateResultRules> rules) {
        this.rules = rules;
    }

    public SimulateResultPoliciesItems status(SimulateResultStatus status) {

        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SimulateResultStatus getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(SimulateResultStatus status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SimulateResultPoliciesItems simulateResultPoliciesItems = (SimulateResultPoliciesItems) o;
        return Objects.equals(this.conditions, simulateResultPoliciesItems.conditions)
                && Objects.equals(this.id, simulateResultPoliciesItems.id)
                && Objects.equals(this.name, simulateResultPoliciesItems.name)
                && Objects.equals(this.rules, simulateResultPoliciesItems.rules)
                && Objects.equals(this.status, simulateResultPoliciesItems.status);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(conditions, id, name, rules, status);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SimulateResultPoliciesItems {\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
