package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertionSubjectConfirmationData;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SAMLPayLoadDataAssertionSubjectConfirmation
 */
@JsonPropertyOrder({ SAMLPayLoadDataAssertionSubjectConfirmation.JSON_PROPERTY_METHOD,
        SAMLPayLoadDataAssertionSubjectConfirmation.JSON_PROPERTY_DATA })
@JsonTypeName("SAMLPayLoad_data_assertion_subject_confirmation")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SAMLPayLoadDataAssertionSubjectConfirmation implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_METHOD = "method";
    private String method;

    public static final String JSON_PROPERTY_DATA = "data";
    private SAMLPayLoadDataAssertionSubjectConfirmationData data;

    public SAMLPayLoadDataAssertionSubjectConfirmation() {
    }

    public SAMLPayLoadDataAssertionSubjectConfirmation method(String method) {

        this.method = method;
        return this;
    }

    /**
     * Used to indicate how the authorization server confirmed the SAML assertion
     *
     * @return method
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "urn:oasis:names:tc:SAML:2.0:cm:bearer", value = "Used to indicate how the authorization server confirmed the SAML assertion")
    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getMethod() {
        return method;
    }

    @JsonProperty(JSON_PROPERTY_METHOD)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMethod(String method) {
        this.method = method;
    }

    public SAMLPayLoadDataAssertionSubjectConfirmation data(SAMLPayLoadDataAssertionSubjectConfirmationData data) {

        this.data = data;
        return this;
    }

    /**
     * Get data
     *
     * @return data
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SAMLPayLoadDataAssertionSubjectConfirmationData getData() {
        return data;
    }

    @JsonProperty(JSON_PROPERTY_DATA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setData(SAMLPayLoadDataAssertionSubjectConfirmationData data) {
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SAMLPayLoadDataAssertionSubjectConfirmation saMLPayLoadDataAssertionSubjectConfirmation = (SAMLPayLoadDataAssertionSubjectConfirmation) o;
        return Objects.equals(this.method, saMLPayLoadDataAssertionSubjectConfirmation.method)
                && Objects.equals(this.data, saMLPayLoadDataAssertionSubjectConfirmation.data);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(method, data);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLPayLoadDataAssertionSubjectConfirmation {\n");
        sb.append("    method: ").append(toIndentedString(method)).append("\n");
        sb.append("    data: ").append(toIndentedString(data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
