package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SecurityEventSubject;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The subject&#39;s identifier has changed, which is either an email address or a phone number change
 */
@ApiModel(description = "The subject's identifier has changed, which is either an email address or a phone number change")
@JsonPropertyOrder({ RiscIdentifierChangedEvent.JSON_PROPERTY_EVENT_TIMESTAMP,
        RiscIdentifierChangedEvent.JSON_PROPERTY_NEW_VALUE, RiscIdentifierChangedEvent.JSON_PROPERTY_SUBJECT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class RiscIdentifierChangedEvent implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EVENT_TIMESTAMP = "event_timestamp";
    private Long eventTimestamp;

    public static final String JSON_PROPERTY_NEW_VALUE = "new-value";
    private String newValue;

    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private SecurityEventSubject subject;

    public RiscIdentifierChangedEvent() {
    }

    public RiscIdentifierChangedEvent eventTimestamp(Long eventTimestamp) {

        this.eventTimestamp = eventTimestamp;
        return this;
    }

    /**
     * The time of the event (UNIX timestamp)
     *
     * @return eventTimestamp
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "1702448550", required = true, value = "The time of the event (UNIX timestamp)")
    @JsonProperty(JSON_PROPERTY_EVENT_TIMESTAMP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public Long getEventTimestamp() {
        return eventTimestamp;
    }

    @JsonProperty(JSON_PROPERTY_EVENT_TIMESTAMP)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setEventTimestamp(Long eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public RiscIdentifierChangedEvent newValue(String newValue) {

        this.newValue = newValue;
        return this;
    }

    /**
     * The new identifier value
     *
     * @return newValue
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "new.email@okta.example.com", value = "The new identifier value")
    @JsonProperty(JSON_PROPERTY_NEW_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getNewValue() {
        return newValue;
    }

    @JsonProperty(JSON_PROPERTY_NEW_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public RiscIdentifierChangedEvent subject(SecurityEventSubject subject) {

        this.subject = subject;
        return this;
    }

    /**
     * Get subject
     *
     * @return subject
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public SecurityEventSubject getSubject() {
        return subject;
    }

    @JsonProperty(JSON_PROPERTY_SUBJECT)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSubject(SecurityEventSubject subject) {
        this.subject = subject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RiscIdentifierChangedEvent riscIdentifierChangedEvent = (RiscIdentifierChangedEvent) o;
        return Objects.equals(this.eventTimestamp, riscIdentifierChangedEvent.eventTimestamp)
                && Objects.equals(this.newValue, riscIdentifierChangedEvent.newValue)
                && Objects.equals(this.subject, riscIdentifierChangedEvent.subject);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(eventTimestamp, newValue, subject);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RiscIdentifierChangedEvent {\n");
        sb.append("    eventTimestamp: ").append(toIndentedString(eventTimestamp)).append("\n");
        sb.append("    newValue: ").append(toIndentedString(newValue)).append("\n");
        sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
