package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ProvisioningConnectionTokenAuthScheme;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ProvisioningConnectionTokenRequestProfile
 */
@JsonPropertyOrder({ ProvisioningConnectionTokenRequestProfile.JSON_PROPERTY_AUTH_SCHEME,
        ProvisioningConnectionTokenRequestProfile.JSON_PROPERTY_TOKEN })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ProvisioningConnectionTokenRequestProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTH_SCHEME = "authScheme";
    private ProvisioningConnectionTokenAuthScheme authScheme;

    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;

    public ProvisioningConnectionTokenRequestProfile() {
    }

    public ProvisioningConnectionTokenRequestProfile authScheme(ProvisioningConnectionTokenAuthScheme authScheme) {

        this.authScheme = authScheme;
        return this;
    }

    /**
     * Get authScheme
     *
     * @return authScheme
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_AUTH_SCHEME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public ProvisioningConnectionTokenAuthScheme getAuthScheme() {
        return authScheme;
    }

    @JsonProperty(JSON_PROPERTY_AUTH_SCHEME)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAuthScheme(ProvisioningConnectionTokenAuthScheme authScheme) {
        this.authScheme = authScheme;
    }

    public ProvisioningConnectionTokenRequestProfile token(String token) {

        this.token = token;
        return this;
    }

    /**
     * Token used to authenticate with the app
     *
     * @return token
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Token used to authenticate with the app")
    @JsonProperty(JSON_PROPERTY_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getToken() {
        return token;
    }

    @JsonProperty(JSON_PROPERTY_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ProvisioningConnectionTokenRequestProfile provisioningConnectionTokenRequestProfile = (ProvisioningConnectionTokenRequestProfile) o;
        return Objects.equals(this.authScheme, provisioningConnectionTokenRequestProfile.authScheme)
                && Objects.equals(this.token, provisioningConnectionTokenRequestProfile.token);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authScheme, token);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProvisioningConnectionTokenRequestProfile {\n");
        sb.append("    authScheme: ").append(toIndentedString(authScheme)).append("\n");
        sb.append("    token: ").append(toIndentedString(token)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
