package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.PasswordCredentialHash;
import com.okta.sdk.resource.model.PasswordCredentialHook;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies a password for a user. When a User has a valid password, imported hashed password, or password hook, and a
 * response object contains a password credential, then the password object is a bare object without the value property
 * defined (for example, &#x60;password: {}&#x60;). This indicates that a password value exists. You can modify password
 * policy requirements in the Admin Console by editing the Password authenticator: **Security** &gt; **Authenticators**
 * &gt; **Password** (or for Okta Classic orgs, use **Security** &gt; **Authentication** &gt; **Password**). For
 * information on defaults and configuring your password policies, see [Configure the password
 * authenticator](https://help.okta.com/okta_help.htm?type&#x3D;oie&amp;id&#x3D;ext-configure-password) in the help
 * documentation.
 */
@ApiModel(description = "Specifies a password for a user.  When a User has a valid password, imported hashed password, or password hook, and a response object contains a password credential, then the password object is a bare object without the value property defined (for example, `password: {}`). This  indicates that a password value exists. You can modify password policy requirements in the Admin Console by editing the Password authenticator:  **Security** > **Authenticators** > **Password** (or for Okta Classic orgs, use **Security** > **Authentication** > **Password**).  For information on defaults and configuring your password policies, see [Configure the password authenticator](https://help.okta.com/okta_help.htm?type=oie&id=ext-configure-password) in the help documentation.")
@JsonPropertyOrder({ PasswordCredential.JSON_PROPERTY_HASH, PasswordCredential.JSON_PROPERTY_HOOK,
        PasswordCredential.JSON_PROPERTY_VALUE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class PasswordCredential implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_HASH = "hash";
    private PasswordCredentialHash hash;

    public static final String JSON_PROPERTY_HOOK = "hook";
    private PasswordCredentialHook hook;

    public static final String JSON_PROPERTY_VALUE = "value";
    private String value;

    public PasswordCredential() {
    }

    public PasswordCredential hash(PasswordCredentialHash hash) {

        this.hash = hash;
        return this;
    }

    /**
     * Get hash
     *
     * @return hash
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HASH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordCredentialHash getHash() {
        return hash;
    }

    @JsonProperty(JSON_PROPERTY_HASH)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHash(PasswordCredentialHash hash) {
        this.hash = hash;
    }

    public PasswordCredential hook(PasswordCredentialHook hook) {

        this.hook = hook;
        return this;
    }

    /**
     * Get hook
     *
     * @return hook
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_HOOK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordCredentialHook getHook() {
        return hook;
    }

    @JsonProperty(JSON_PROPERTY_HOOK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setHook(PasswordCredentialHook hook) {
        this.hook = hook;
    }

    public PasswordCredential value(String value) {

        this.value = value;
        return this;
    }

    /**
     * Specifies the password for a user. The Password Policy validates this password.
     *
     * @return value
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "pa$$word", value = "Specifies the password for a user. The Password Policy validates this password.")
    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getValue() {
        return value;
    }

    @JsonProperty(JSON_PROPERTY_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PasswordCredential passwordCredential = (PasswordCredential) o;
        return Objects.equals(this.hash, passwordCredential.hash) && Objects.equals(this.hook, passwordCredential.hook)
                && Objects.equals(this.value, passwordCredential.value);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(hash, hook, value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PasswordCredential {\n");
        sb.append("    hash: ").append(toIndentedString(hash)).append("\n");
        sb.append("    hook: ").append(toIndentedString(hook)).append("\n");
        sb.append("    value: ").append(toIndentedString(value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
