package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OrgPreferencesLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OrgPreferences
 */
@JsonPropertyOrder({ OrgPreferences.JSON_PROPERTY_SHOW_END_USER_FOOTER, OrgPreferences.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OrgPreferences implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SHOW_END_USER_FOOTER = "showEndUserFooter";
    private Boolean showEndUserFooter;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private OrgPreferencesLinks links;

    public OrgPreferences() {
    }

    /*
     * @JsonCreator public OrgPreferences(
     *
     * @JsonProperty(JSON_PROPERTY_SHOW_END_USER_FOOTER) Boolean showEndUserFooter ) { this(); this.showEndUserFooter =
     * showEndUserFooter; }
     */

    /**
     * Indicates if the footer is shown on the End-User Dashboard
     *
     * @return showEndUserFooter
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if the footer is shown on the End-User Dashboard")
    @JsonProperty(JSON_PROPERTY_SHOW_END_USER_FOOTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getShowEndUserFooter() {
        return showEndUserFooter;
    }

    public OrgPreferences links(OrgPreferencesLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OrgPreferencesLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OrgPreferencesLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OrgPreferences orgPreferences = (OrgPreferences) o;
        return Objects.equals(this.showEndUserFooter, orgPreferences.showEndUserFooter)
                && Objects.equals(this.links, orgPreferences.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(showEndUserFooter, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgPreferences {\n");
        sb.append("    showEndUserFooter: ").append(toIndentedString(showEndUserFooter)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
