package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The type of client app Specific &#x60;grant_types&#x60; are valid for each &#x60;application_type&#x60;. See [Create
 * a Client Application](/openapi/okta-oauth/oauth/tag/Client/#tag/Client/operation/createClient).
 */
public enum OpenIdConnectApplicationType {

    BROWSER("browser"),

    NATIVE("native"),

    SERVICE("service"),

    WEB("web"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    OpenIdConnectApplicationType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static OpenIdConnectApplicationType fromValue(String value) {
        for (OpenIdConnectApplicationType b : OpenIdConnectApplicationType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
