package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OpenIdConnectRefreshTokenRotationType;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Refresh token configuration for an OAuth 2.0 client When you create or update an OAuth 2.0 client, you can configure
 * refresh token rotation by setting the &#x60;rotation_type&#x60; and &#x60;leeway&#x60; properties. If you don&#39;t
 * set these properties when you create an app integration, the default values are used. When you update an app
 * integration, your previously configured values are used.
 */
@ApiModel(description = "Refresh token configuration for an OAuth 2.0 client  When you create or update an OAuth 2.0 client, you can configure refresh token rotation by setting the `rotation_type` and `leeway` properties. If you don't set these properties when you create an app integration, the default values are used. When you update an app integration, your previously configured values are used. ")
@JsonPropertyOrder({ OpenIdConnectApplicationSettingsRefreshToken.JSON_PROPERTY_LEEWAY,
        OpenIdConnectApplicationSettingsRefreshToken.JSON_PROPERTY_ROTATION_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OpenIdConnectApplicationSettingsRefreshToken implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_LEEWAY = "leeway";
    private Integer leeway = 30;

    public static final String JSON_PROPERTY_ROTATION_TYPE = "rotation_type";
    private OpenIdConnectRefreshTokenRotationType rotationType;

    public OpenIdConnectApplicationSettingsRefreshToken() {
    }

    public OpenIdConnectApplicationSettingsRefreshToken leeway(Integer leeway) {

        this.leeway = leeway;
        return this;
    }

    /**
     * The leeway, in seconds, allowed for the OAuth 2.0 client. After the refresh token is rotated, the previous token
     * remains valid for the specified period of time so clients can get the new token. &gt; **Note:** A leeway of 0
     * doesn&#39;t necessarily mean that the previous token is immediately invalidated. The previous token is
     * invalidated after the new token is generated and returned in the response. minimum: 0 maximum: 60
     *
     * @return leeway
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "20", value = "The leeway, in seconds, allowed for the OAuth 2.0 client. After the refresh token is rotated, the previous token remains valid for the specified period of time so clients can get the new token.  > **Note:** A leeway of 0 doesn't necessarily mean that the previous token is immediately invalidated. The previous token is invalidated after the new token is generated and returned in the response. ")
    @JsonProperty(JSON_PROPERTY_LEEWAY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Integer getLeeway() {
        return leeway;
    }

    @JsonProperty(JSON_PROPERTY_LEEWAY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLeeway(Integer leeway) {
        this.leeway = leeway;
    }

    public OpenIdConnectApplicationSettingsRefreshToken rotationType(
            OpenIdConnectRefreshTokenRotationType rotationType) {

        this.rotationType = rotationType;
        return this;
    }

    /**
     * Get rotationType
     *
     * @return rotationType
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_ROTATION_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public OpenIdConnectRefreshTokenRotationType getRotationType() {
        return rotationType;
    }

    @JsonProperty(JSON_PROPERTY_ROTATION_TYPE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setRotationType(OpenIdConnectRefreshTokenRotationType rotationType) {
        this.rotationType = rotationType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OpenIdConnectApplicationSettingsRefreshToken openIdConnectApplicationSettingsRefreshToken = (OpenIdConnectApplicationSettingsRefreshToken) o;
        return Objects.equals(this.leeway, openIdConnectApplicationSettingsRefreshToken.leeway)
                && Objects.equals(this.rotationType, openIdConnectApplicationSettingsRefreshToken.rotationType);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(leeway, rotationType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenIdConnectApplicationSettingsRefreshToken {\n");
        sb.append("    leeway: ").append(toIndentedString(leeway)).append("\n");
        sb.append("    rotationType: ").append(toIndentedString(rotationType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
