package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Array of OAuth 2.0 grant type strings
 */
public enum OAuthGrantType {

    AUTHORIZATION_CODE("authorization_code"),

    CLIENT_CREDENTIALS("client_credentials"),

    IMPLICIT("implicit"),

    INTERACTION_CODE("interaction_code"),

    PASSWORD("password"),

    REFRESH_TOKEN("refresh_token"),

    URN_IETF_PARAMS_OAUTH_GRANT_TYPE_DEVICE_CODE("urn:ietf:params:oauth:grant-type:device_code"),

    URN_IETF_PARAMS_OAUTH_GRANT_TYPE_JWT_BEARER("urn:ietf:params:oauth:grant-type:jwt-bearer"),

    URN_IETF_PARAMS_OAUTH_GRANT_TYPE_SAML2_BEARER("urn:ietf:params:oauth:grant-type:saml2-bearer"),

    URN_IETF_PARAMS_OAUTH_GRANT_TYPE_TOKEN_EXCHANGE("urn:ietf:params:oauth:grant-type:token-exchange"),

    URN_OPENID_PARAMS_GRANT_TYPE_CIBA("urn:openid:params:grant-type:ciba"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    OAuthGrantType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static OAuthGrantType fromValue(String value) {
        for (OAuthGrantType b : OAuthGrantType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
