package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuth2ClientLinks;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * OAuth2Client
 */
@JsonPropertyOrder({ OAuth2Client.JSON_PROPERTY_CLIENT_ID, OAuth2Client.JSON_PROPERTY_CLIENT_NAME,
        OAuth2Client.JSON_PROPERTY_CLIENT_URI, OAuth2Client.JSON_PROPERTY_LOGO_URI, OAuth2Client.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class OAuth2Client implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLIENT_ID = "client_id";
    private String clientId;

    public static final String JSON_PROPERTY_CLIENT_NAME = "client_name";
    private String clientName;

    public static final String JSON_PROPERTY_CLIENT_URI = "client_uri";
    private String clientUri;

    public static final String JSON_PROPERTY_LOGO_URI = "logo_uri";
    private String logoUri;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private OAuth2ClientLinks links;

    public OAuth2Client() {
    }

    /*
     * @JsonCreator public OAuth2Client(
     *
     * @JsonProperty(JSON_PROPERTY_CLIENT_ID) String clientId,
     *
     * @JsonProperty(JSON_PROPERTY_CLIENT_NAME) String clientName,
     *
     * @JsonProperty(JSON_PROPERTY_CLIENT_URI) String clientUri,
     *
     * @JsonProperty(JSON_PROPERTY_LOGO_URI) String logoUri ) { this(); this.clientId = clientId; this.clientName =
     * clientName; this.clientUri = clientUri; this.logoUri = logoUri; }
     */

    /**
     * Unique key for the client application. The &#x60;client_id&#x60; is immutable.
     *
     * @return clientId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "0oabskvc6442nkvQO0h7", value = "Unique key for the client application. The `client_id` is immutable.")
    @JsonProperty(JSON_PROPERTY_CLIENT_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientId() {
        return clientId;
    }

    /**
     * Human-readable string name of the client application
     *
     * @return clientName
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "My App", value = "Human-readable string name of the client application")
    @JsonProperty(JSON_PROPERTY_CLIENT_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientName() {
        return clientName;
    }

    /**
     * Get clientUri
     *
     * @return clientUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://www.example.com", value = "")
    @JsonProperty(JSON_PROPERTY_CLIENT_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getClientUri() {
        return clientUri;
    }

    /**
     * URL string that references a logo for the client consent dialog (not the sign-in dialog)
     *
     * @return logoUri
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "https://www.example.com/logo.png", value = "URL string that references a logo for the client consent dialog (not the sign-in dialog)")
    @JsonProperty(JSON_PROPERTY_LOGO_URI)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getLogoUri() {
        return logoUri;
    }

    public OAuth2Client links(OAuth2ClientLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OAuth2ClientLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(OAuth2ClientLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OAuth2Client oauth2Client = (OAuth2Client) o;
        return Objects.equals(this.clientId, oauth2Client.clientId)
                && Objects.equals(this.clientName, oauth2Client.clientName)
                && Objects.equals(this.clientUri, oauth2Client.clientUri)
                && Objects.equals(this.logoUri, oauth2Client.logoUri) && Objects.equals(this.links, oauth2Client.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(clientId, clientName, clientUri, logoUri, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2Client {\n");
        sb.append("    clientId: ").append(toIndentedString(clientId)).append("\n");
        sb.append("    clientName: ").append(toIndentedString(clientName)).append("\n");
        sb.append("    clientUri: ").append(toIndentedString(clientUri)).append("\n");
        sb.append("    logoUri: ").append(toIndentedString(logoUri)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
