package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Specifies the type of group filter if &#x60;valueType&#x60; is &#x60;GROUPS&#x60; If &#x60;valueType&#x60; is
 * &#x60;GROUPS&#x60;, then the groups returned are filtered according to the value of &#x60;group_filter_type&#x60;. If
 * you have complex filters for Groups, you can [create a Groups
 * allowlist](https://developer.okta.com/docs/guides/customize-tokens-groups-claim/main/) to put them all in a Claim.
 */
public enum OAuth2ClaimGroupFilterType {

    CONTAINS("CONTAINS"),

    EQUALS("EQUALS"),

    REGEX("REGEX"),

    STARTS_WITH("STARTS_WITH"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    OAuth2ClaimGroupFilterType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static OAuth2ClaimGroupFilterType fromValue(String value) {
        for (OAuth2ClaimGroupFilterType b : OAuth2ClaimGroupFilterType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
