package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * The type of notification
 */
public enum NotificationType {

    AD_AGENT("AD_AGENT"),

    AGENT_AUTO_UPDATE_NOTIFICATION("AGENT_AUTO_UPDATE_NOTIFICATION"),

    AGENT_AUTO_UPDATE_NOTIFICATION_LDAP("AGENT_AUTO_UPDATE_NOTIFICATION_LDAP"),

    APP_IMPORT("APP_IMPORT"),

    CONNECTOR_AGENT("CONNECTOR_AGENT"),

    IWA_AGENT("IWA_AGENT"),

    LDAP_AGENT("LDAP_AGENT"),

    OKTA_ANNOUNCEMENT("OKTA_ANNOUNCEMENT"),

    OKTA_ISSUE("OKTA_ISSUE"),

    OKTA_UPDATE("OKTA_UPDATE"),

    RATELIMIT_NOTIFICATION("RATELIMIT_NOTIFICATION"),

    REPORT_SUSPICIOUS_ACTIVITY("REPORT_SUSPICIOUS_ACTIVITY"),

    USER_DEPROVISION("USER_DEPROVISION"),

    USER_LOCKED_OUT("USER_LOCKED_OUT"),

    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    NotificationType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static NotificationType fromValue(String value) {
        for (NotificationType b : NotificationType.values()) {
            if (b.value.equals(value)) {
                return b;
            }
        }
        return UNKNOWN_DEFAULT_OPEN_API;
    }

    /**
     * Convert the instance into URL query string.
     *
     * @param prefix
     *            prefix of the query string
     *
     * @return URL query string
     */
    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }

        return String.format("%s=%s", prefix, this.toString().toString());
    }
}
