package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.HrefObjectAssigneeLink;
import com.okta.sdk.resource.model.HrefObjectMemberLink;
import com.okta.sdk.resource.model.HrefObjectPermissionsLink;
import com.okta.sdk.resource.model.HrefObjectResourceSetLink;
import com.okta.sdk.resource.model.HrefObjectRoleLink;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available using the [JSON
 * Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. This
 * object is used for dynamic discovery of related resources.
 */
@ApiModel(description = "Specifies link relations (see [Web Linking](https://www.rfc-editor.org/rfc/rfc8288)) available using the [JSON Hypertext Application Language](https://datatracker.ietf.org/doc/html/draft-kelly-json-hal-06) specification. This object is used for dynamic discovery of related resources.")
@JsonPropertyOrder({ LinksCustomRoleResponse.JSON_PROPERTY_ASSIGNEE, LinksCustomRoleResponse.JSON_PROPERTY_MEMBER,
        LinksCustomRoleResponse.JSON_PROPERTY_PERMISSIONS, LinksCustomRoleResponse.JSON_PROPERTY_RESOURCE_SET,
        LinksCustomRoleResponse.JSON_PROPERTY_ROLE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class LinksCustomRoleResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
    private HrefObjectAssigneeLink assignee;

    public static final String JSON_PROPERTY_MEMBER = "member";
    private HrefObjectMemberLink member;

    public static final String JSON_PROPERTY_PERMISSIONS = "permissions";
    private HrefObjectPermissionsLink permissions;

    public static final String JSON_PROPERTY_RESOURCE_SET = "resource-set";
    private HrefObjectResourceSetLink resourceSet;

    public static final String JSON_PROPERTY_ROLE = "role";
    private HrefObjectRoleLink role;

    public LinksCustomRoleResponse() {
    }

    public LinksCustomRoleResponse assignee(HrefObjectAssigneeLink assignee) {

        this.assignee = assignee;
        return this;
    }

    /**
     * Get assignee
     *
     * @return assignee
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ASSIGNEE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectAssigneeLink getAssignee() {
        return assignee;
    }

    @JsonProperty(JSON_PROPERTY_ASSIGNEE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAssignee(HrefObjectAssigneeLink assignee) {
        this.assignee = assignee;
    }

    public LinksCustomRoleResponse member(HrefObjectMemberLink member) {

        this.member = member;
        return this;
    }

    /**
     * Get member
     *
     * @return member
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_MEMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectMemberLink getMember() {
        return member;
    }

    @JsonProperty(JSON_PROPERTY_MEMBER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setMember(HrefObjectMemberLink member) {
        this.member = member;
    }

    public LinksCustomRoleResponse permissions(HrefObjectPermissionsLink permissions) {

        this.permissions = permissions;
        return this;
    }

    /**
     * Get permissions
     *
     * @return permissions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PERMISSIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectPermissionsLink getPermissions() {
        return permissions;
    }

    @JsonProperty(JSON_PROPERTY_PERMISSIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPermissions(HrefObjectPermissionsLink permissions) {
        this.permissions = permissions;
    }

    public LinksCustomRoleResponse resourceSet(HrefObjectResourceSetLink resourceSet) {

        this.resourceSet = resourceSet;
        return this;
    }

    /**
     * Get resourceSet
     *
     * @return resourceSet
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RESOURCE_SET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectResourceSetLink getResourceSet() {
        return resourceSet;
    }

    @JsonProperty(JSON_PROPERTY_RESOURCE_SET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResourceSet(HrefObjectResourceSetLink resourceSet) {
        this.resourceSet = resourceSet;
    }

    public LinksCustomRoleResponse role(HrefObjectRoleLink role) {

        this.role = role;
        return this;
    }

    /**
     * Get role
     *
     * @return role
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ROLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public HrefObjectRoleLink getRole() {
        return role;
    }

    @JsonProperty(JSON_PROPERTY_ROLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRole(HrefObjectRoleLink role) {
        this.role = role;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinksCustomRoleResponse linksCustomRoleResponse = (LinksCustomRoleResponse) o;
        return Objects.equals(this.assignee, linksCustomRoleResponse.assignee)
                && Objects.equals(this.member, linksCustomRoleResponse.member)
                && Objects.equals(this.permissions, linksCustomRoleResponse.permissions)
                && Objects.equals(this.resourceSet, linksCustomRoleResponse.resourceSet)
                && Objects.equals(this.role, linksCustomRoleResponse.role);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(assignee, member, permissions, resourceSet, role);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinksCustomRoleResponse {\n");
        sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
        sb.append("    member: ").append(toIndentedString(member)).append("\n");
        sb.append("    permissions: ").append(toIndentedString(permissions)).append("\n");
        sb.append("    resourceSet: ").append(toIndentedString(resourceSet)).append("\n");
        sb.append("    role: ").append(toIndentedString(role)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
