package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.JsonWebKeyStatus;
import com.okta.sdk.resource.model.JsonWebKeyType;
import com.okta.sdk.resource.model.JsonWebKeyUse;
import com.okta.sdk.resource.model.SchemasJsonWebKey;
import com.okta.sdk.resource.model.SigningAlgorithm;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * JsonWebKeyRsa
 */
@JsonPropertyOrder({ JsonWebKeyRsa.JSON_PROPERTY_E, JsonWebKeyRsa.JSON_PROPERTY_N })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "kty", visible = true, defaultImpl = JsonWebKeyRsa.class)

public class JsonWebKeyRsa extends SchemasJsonWebKey implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_E = "e";
    private String e;

    public static final String JSON_PROPERTY_N = "n";
    private String n;

    public JsonWebKeyRsa() {
    }

    public JsonWebKeyRsa e(String e) {

        this.e = e;
        return this;
    }

    /**
     * The key exponent of a RSA key
     *
     * @return e
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The key exponent of a RSA key")
    @JsonProperty(JSON_PROPERTY_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getE() {
        return e;
    }

    @JsonProperty(JSON_PROPERTY_E)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setE(String e) {
        this.e = e;
    }

    public JsonWebKeyRsa n(String n) {

        this.n = n;
        return this;
    }

    /**
     * The modulus of the RSA key
     *
     * @return n
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The modulus of the RSA key")
    @JsonProperty(JSON_PROPERTY_N)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getN() {
        return n;
    }

    @JsonProperty(JSON_PROPERTY_N)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setN(String n) {
        this.n = n;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        JsonWebKeyRsa jsonWebKeyRsa = (JsonWebKeyRsa) o;
        return Objects.equals(this.e, jsonWebKeyRsa.e) && Objects.equals(this.n, jsonWebKeyRsa.n);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(e, n, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonWebKeyRsa {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    e: ").append(toIndentedString(e)).append("\n");
        sb.append("    n: ").append(toIndentedString(n)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
