package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openapitools.jackson.nullable.JsonNullable;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.openapitools.jackson.nullable.JsonNullable;
import java.util.NoSuchElementException;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ErrorResponse
 */
@JsonPropertyOrder({ ErrorResponse.JSON_PROPERTY_ERROR_CAUSE, ErrorResponse.JSON_PROPERTY_ERROR_CODE,
        ErrorResponse.JSON_PROPERTY_ERROR_ID, ErrorResponse.JSON_PROPERTY_ERROR_LINK,
        ErrorResponse.JSON_PROPERTY_ERROR_SUMMARY })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ErrorResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ERROR_CAUSE = "errorCause";
    private JsonNullable<String> errorCause = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
    private String errorCode;

    public static final String JSON_PROPERTY_ERROR_ID = "errorId";
    private JsonNullable<String> errorId = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_ERROR_LINK = "errorLink";
    private JsonNullable<String> errorLink = JsonNullable.<String> undefined();

    public static final String JSON_PROPERTY_ERROR_SUMMARY = "errorSummary";
    private String errorSummary;

    public ErrorResponse() {
    }

    public ErrorResponse errorCause(String errorCause) {
        this.errorCause = JsonNullable.<String> of(errorCause);

        return this;
    }

    /**
     * The reason or cause for the error in the org domain for the dr operation
     *
     * @return errorCause
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The reason or cause for the error in the org domain for the dr operation")
    @JsonIgnore

    public String getErrorCause() {
        return errorCause.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_ERROR_CAUSE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getErrorCause_JsonNullable() {
        return errorCause;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_CAUSE)
    public void setErrorCause_JsonNullable(JsonNullable<String> errorCause) {
        this.errorCause = errorCause;
    }

    public void setErrorCause(String errorCause) {
        this.errorCause = JsonNullable.<String> of(errorCause);
    }

    public ErrorResponse errorCode(String errorCode) {

        this.errorCode = errorCode;
        return this;
    }

    /**
     * An error code unique to the error
     *
     * @return errorCode
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "An error code unique to the error")
    @JsonProperty(JSON_PROPERTY_ERROR_CODE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getErrorCode() {
        return errorCode;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_CODE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public ErrorResponse errorId(String errorId) {
        this.errorId = JsonNullable.<String> of(errorId);

        return this;
    }

    /**
     * The unique identifier of this error
     *
     * @return errorId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The unique identifier of this error")
    @JsonIgnore

    public String getErrorId() {
        return errorId.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_ERROR_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getErrorId_JsonNullable() {
        return errorId;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_ID)
    public void setErrorId_JsonNullable(JsonNullable<String> errorId) {
        this.errorId = errorId;
    }

    public void setErrorId(String errorId) {
        this.errorId = JsonNullable.<String> of(errorId);
    }

    public ErrorResponse errorLink(String errorLink) {
        this.errorLink = JsonNullable.<String> of(errorLink);

        return this;
    }

    /**
     * An indicator where to look out to troubleshoot the error
     *
     * @return errorLink
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "An indicator where to look out to troubleshoot the error")
    @JsonIgnore

    public String getErrorLink() {
        return errorLink.orElse(null);
    }

    @JsonProperty(JSON_PROPERTY_ERROR_LINK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public JsonNullable<String> getErrorLink_JsonNullable() {
        return errorLink;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_LINK)
    public void setErrorLink_JsonNullable(JsonNullable<String> errorLink) {
        this.errorLink = errorLink;
    }

    public void setErrorLink(String errorLink) {
        this.errorLink = JsonNullable.<String> of(errorLink);
    }

    public ErrorResponse errorSummary(String errorSummary) {

        this.errorSummary = errorSummary;
        return this;
    }

    /**
     * An error code description, detailing the error
     *
     * @return errorSummary
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "An error code description, detailing the error")
    @JsonProperty(JSON_PROPERTY_ERROR_SUMMARY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getErrorSummary() {
        return errorSummary;
    }

    @JsonProperty(JSON_PROPERTY_ERROR_SUMMARY)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setErrorSummary(String errorSummary) {
        this.errorSummary = errorSummary;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ErrorResponse errorResponse = (ErrorResponse) o;
        return equalsNullable(this.errorCause, errorResponse.errorCause)
                && Objects.equals(this.errorCode, errorResponse.errorCode)
                && equalsNullable(this.errorId, errorResponse.errorId)
                && equalsNullable(this.errorLink, errorResponse.errorLink)
                && Objects.equals(this.errorSummary, errorResponse.errorSummary);
        // ;
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b
                || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(hashCodeNullable(errorCause), errorCode, hashCodeNullable(errorId),
                hashCodeNullable(errorLink), errorSummary);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[] { a.get() }) : 31;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ErrorResponse {\n");
        sb.append("    errorCause: ").append(toIndentedString(errorCause)).append("\n");
        sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
        sb.append("    errorId: ").append(toIndentedString(errorId)).append("\n");
        sb.append("    errorLink: ").append(toIndentedString(errorLink)).append("\n");
        sb.append("    errorSummary: ").append(toIndentedString(errorSummary)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
