package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * CustomRoleAssignmentSchema
 */
@JsonPropertyOrder({ CustomRoleAssignmentSchema.JSON_PROPERTY_RESOURCE_SET,
        CustomRoleAssignmentSchema.JSON_PROPERTY_ROLE, CustomRoleAssignmentSchema.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class CustomRoleAssignmentSchema implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_RESOURCE_SET = "resource-set";
    private String resourceSet;

    public static final String JSON_PROPERTY_ROLE = "role";
    private String role;

    /**
     * The type of role. Specify &#x60;CUSTOM&#x60; for a custom role.
     */
    public enum TypeEnum {
        CUSTOM(String.valueOf("CUSTOM")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public CustomRoleAssignmentSchema() {
    }

    public CustomRoleAssignmentSchema resourceSet(String resourceSet) {

        this.resourceSet = resourceSet;
        return this;
    }

    /**
     * Resource Set ID
     *
     * @return resourceSet
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Resource Set ID")
    @JsonProperty(JSON_PROPERTY_RESOURCE_SET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getResourceSet() {
        return resourceSet;
    }

    @JsonProperty(JSON_PROPERTY_RESOURCE_SET)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResourceSet(String resourceSet) {
        this.resourceSet = resourceSet;
    }

    public CustomRoleAssignmentSchema role(String role) {

        this.role = role;
        return this;
    }

    /**
     * Custom Role ID
     *
     * @return role
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Custom Role ID")
    @JsonProperty(JSON_PROPERTY_ROLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRole() {
        return role;
    }

    @JsonProperty(JSON_PROPERTY_ROLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRole(String role) {
        this.role = role;
    }

    public CustomRoleAssignmentSchema type(TypeEnum type) {

        this.type = type;
        return this;
    }

    /**
     * The type of role. Specify &#x60;CUSTOM&#x60; for a custom role.
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The type of role. Specify `CUSTOM` for a custom role.")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CustomRoleAssignmentSchema customRoleAssignmentSchema = (CustomRoleAssignmentSchema) o;
        return Objects.equals(this.resourceSet, customRoleAssignmentSchema.resourceSet)
                && Objects.equals(this.role, customRoleAssignmentSchema.role)
                && Objects.equals(this.type, customRoleAssignmentSchema.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourceSet, role, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomRoleAssignmentSchema {\n");
        sb.append("    resourceSet: ").append(toIndentedString(resourceSet)).append("\n");
        sb.append("    role: ").append(toIndentedString(role)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
