package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CreateUserRequestType;
import com.okta.sdk.resource.model.UserCredentials;
import com.okta.sdk.resource.model.UserProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * CreateUserRequest
 */
@JsonPropertyOrder({ CreateUserRequest.JSON_PROPERTY_CREDENTIALS, CreateUserRequest.JSON_PROPERTY_GROUP_IDS,
        CreateUserRequest.JSON_PROPERTY_PROFILE, CreateUserRequest.JSON_PROPERTY_REALM_ID,
        CreateUserRequest.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class CreateUserRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private UserCredentials credentials;

    public static final String JSON_PROPERTY_GROUP_IDS = "groupIds";
    private List<String> groupIds = null;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private UserProfile profile;

    public static final String JSON_PROPERTY_REALM_ID = "realmId";
    private String realmId;

    public static final String JSON_PROPERTY_TYPE = "type";
    private CreateUserRequestType type;

    public CreateUserRequest() {
    }

    public CreateUserRequest credentials(UserCredentials credentials) {

        this.credentials = credentials;
        return this;
    }

    /**
     * Get credentials
     *
     * @return credentials
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserCredentials getCredentials() {
        return credentials;
    }

    @JsonProperty(JSON_PROPERTY_CREDENTIALS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(UserCredentials credentials) {
        this.credentials = credentials;
    }

    public CreateUserRequest groupIds(List<String> groupIds) {

        this.groupIds = groupIds;
        return this;
    }

    public CreateUserRequest addgroupIdsItem(String groupIdsItem) {
        if (this.groupIds == null) {
            this.groupIds = new ArrayList<>();
        }
        this.groupIds.add(groupIdsItem);
        return this;
    }

    /**
     * Get groupIds
     *
     * @return groupIds
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GROUP_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getGroupIds() {
        return groupIds;
    }

    @JsonProperty(JSON_PROPERTY_GROUP_IDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroupIds(List<String> groupIds) {
        this.groupIds = groupIds;
    }

    public CreateUserRequest profile(UserProfile profile) {

        this.profile = profile;
        return this;
    }

    /**
     * Get profile
     *
     * @return profile
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public UserProfile getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setProfile(UserProfile profile) {
        this.profile = profile;
    }

    public CreateUserRequest realmId(String realmId) {

        this.realmId = realmId;
        return this;
    }

    /**
     * &lt;div class&#x3D;\&quot;x-lifecycle-container\&quot;&gt;&lt;x-lifecycle
     * class&#x3D;\&quot;ea\&quot;&gt;&lt;/x-lifecycle&gt;&lt;/div&gt;The ID of the Realm in which the User is residing
     *
     * @return realmId
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "guo1bfiNtSnZYILxO0g4", value = "<div class=\"x-lifecycle-container\"><x-lifecycle class=\"ea\"></x-lifecycle></div>The ID of the Realm in which the User is residing")
    @JsonProperty(JSON_PROPERTY_REALM_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRealmId() {
        return realmId;
    }

    @JsonProperty(JSON_PROPERTY_REALM_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    public CreateUserRequest type(CreateUserRequestType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public CreateUserRequestType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(CreateUserRequestType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateUserRequest createUserRequest = (CreateUserRequest) o;
        return Objects.equals(this.credentials, createUserRequest.credentials)
                && Objects.equals(this.groupIds, createUserRequest.groupIds)
                && Objects.equals(this.profile, createUserRequest.profile)
                && Objects.equals(this.realmId, createUserRequest.realmId)
                && Objects.equals(this.type, createUserRequest.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(credentials, groupIds, profile, realmId, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateUserRequest {\n");
        sb.append("    credentials: ").append(toIndentedString(credentials)).append("\n");
        sb.append("    groupIds: ").append(toIndentedString(groupIds)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    realmId: ").append(toIndentedString(realmId)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
