package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.GroupRuleAction;
import com.okta.sdk.resource.model.GroupRuleConditions;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * CreateGroupRuleRequest
 */
@JsonPropertyOrder({ CreateGroupRuleRequest.JSON_PROPERTY_ACTIONS, CreateGroupRuleRequest.JSON_PROPERTY_CONDITIONS,
        CreateGroupRuleRequest.JSON_PROPERTY_NAME, CreateGroupRuleRequest.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class CreateGroupRuleRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ACTIONS = "actions";
    private GroupRuleAction actions;

    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private GroupRuleConditions conditions;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    /**
     * Gets or Sets type
     */
    public enum TypeEnum {
        GROUP_RULE(String.valueOf("group_rule")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public CreateGroupRuleRequest() {
    }

    public CreateGroupRuleRequest actions(GroupRuleAction actions) {

        this.actions = actions;
        return this;
    }

    /**
     * Get actions
     *
     * @return actions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ACTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupRuleAction getActions() {
        return actions;
    }

    @JsonProperty(JSON_PROPERTY_ACTIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setActions(GroupRuleAction actions) {
        this.actions = actions;
    }

    public CreateGroupRuleRequest conditions(GroupRuleConditions conditions) {

        this.conditions = conditions;
        return this;
    }

    /**
     * Get conditions
     *
     * @return conditions
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public GroupRuleConditions getConditions() {
        return conditions;
    }

    @JsonProperty(JSON_PROPERTY_CONDITIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(GroupRuleConditions conditions) {
        this.conditions = conditions;
    }

    public CreateGroupRuleRequest name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Name of the Group rule
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the Group rule")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public CreateGroupRuleRequest type(TypeEnum type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public TypeEnum getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateGroupRuleRequest createGroupRuleRequest = (CreateGroupRuleRequest) o;
        return Objects.equals(this.actions, createGroupRuleRequest.actions)
                && Objects.equals(this.conditions, createGroupRuleRequest.conditions)
                && Objects.equals(this.name, createGroupRuleRequest.name)
                && Objects.equals(this.type, createGroupRuleRequest.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(actions, conditions, name, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateGroupRuleRequest {\n");
        sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
        sb.append("    conditions: ").append(toIndentedString(conditions)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
