package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * BasicApplicationSettingsApplication
 */
@JsonPropertyOrder({ BasicApplicationSettingsApplication.JSON_PROPERTY_AUTH_U_R_L,
        BasicApplicationSettingsApplication.JSON_PROPERTY_URL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class BasicApplicationSettingsApplication implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUTH_U_R_L = "authURL";
    private String authURL;

    public static final String JSON_PROPERTY_URL = "url";
    private String url;

    public BasicApplicationSettingsApplication() {
    }

    public BasicApplicationSettingsApplication authURL(String authURL) {

        this.authURL = authURL;
        return this;
    }

    /**
     * The URL of the authenticating site for this app
     *
     * @return authURL
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The URL of the authenticating site for this app")
    @JsonProperty(JSON_PROPERTY_AUTH_U_R_L)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getAuthURL() {
        return authURL;
    }

    @JsonProperty(JSON_PROPERTY_AUTH_U_R_L)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setAuthURL(String authURL) {
        this.authURL = authURL;
    }

    public BasicApplicationSettingsApplication url(String url) {

        this.url = url;
        return this;
    }

    /**
     * The URL of the sign-in page for this app
     *
     * @return url
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(required = true, value = "The URL of the sign-in page for this app")
    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getUrl() {
        return url;
    }

    @JsonProperty(JSON_PROPERTY_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BasicApplicationSettingsApplication basicApplicationSettingsApplication = (BasicApplicationSettingsApplication) o;
        return Objects.equals(this.authURL, basicApplicationSettingsApplication.authURL)
                && Objects.equals(this.url, basicApplicationSettingsApplication.url);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(authURL, url);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BasicApplicationSettingsApplication {\n");
        sb.append("    authURL: ").append(toIndentedString(authURL)).append("\n");
        sb.append("    url: ").append(toIndentedString(url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
