package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticatorMethodBase;
import com.okta.sdk.resource.model.AuthenticatorMethodProperty;
import com.okta.sdk.resource.model.AuthenticatorMethodType;
import com.okta.sdk.resource.model.LifecycleStatus;
import com.okta.sdk.resource.model.LinksSelfAndLifecycle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AuthenticatorMethodWithVerifiableProperties
 */
@JsonPropertyOrder({ AuthenticatorMethodWithVerifiableProperties.JSON_PROPERTY_VERIFIABLE_PROPERTIES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXISTING_PROPERTY, property = "type", visible = true, defaultImpl = AuthenticatorMethodWithVerifiableProperties.class)
@JsonSubTypes({ @JsonSubTypes.Type(value = AuthenticatorMethodWithVerifiableProperties.class, name = "cert"),
        @JsonSubTypes.Type(value = AuthenticatorMethodWithVerifiableProperties.class, name = "duo"),
        @JsonSubTypes.Type(value = AuthenticatorMethodSimple.class, name = "email"),
        @JsonSubTypes.Type(value = AuthenticatorMethodWithVerifiableProperties.class, name = "idp"),
        @JsonSubTypes.Type(value = AuthenticatorMethodOtp.class, name = "otp"),
        @JsonSubTypes.Type(value = AuthenticatorMethodSimple.class, name = "password"),
        @JsonSubTypes.Type(value = AuthenticatorMethodPush.class, name = "push"),
        @JsonSubTypes.Type(value = AuthenticatorMethodSimple.class, name = "security_question"),
        @JsonSubTypes.Type(value = AuthenticatorMethodSignedNonce.class, name = "signed_nonce"),
        @JsonSubTypes.Type(value = AuthenticatorMethodSimple.class, name = "sms"),
        @JsonSubTypes.Type(value = AuthenticatorMethodTotp.class, name = "totp"),
        @JsonSubTypes.Type(value = AuthenticatorMethodSimple.class, name = "voice"),
        @JsonSubTypes.Type(value = AuthenticatorMethodWebAuthn.class, name = "webauthn"), })

public class AuthenticatorMethodWithVerifiableProperties extends AuthenticatorMethodBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_VERIFIABLE_PROPERTIES = "verifiableProperties";
    private List<AuthenticatorMethodProperty> verifiableProperties = null;

    public AuthenticatorMethodWithVerifiableProperties() {
    }

    public AuthenticatorMethodWithVerifiableProperties verifiableProperties(
            List<AuthenticatorMethodProperty> verifiableProperties) {

        this.verifiableProperties = verifiableProperties;
        return this;
    }

    public AuthenticatorMethodWithVerifiableProperties addverifiablePropertiesItem(
            AuthenticatorMethodProperty verifiablePropertiesItem) {
        if (this.verifiableProperties == null) {
            this.verifiableProperties = new ArrayList<>();
        }
        this.verifiableProperties.add(verifiablePropertiesItem);
        return this;
    }

    /**
     * Get verifiableProperties
     *
     * @return verifiableProperties
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VERIFIABLE_PROPERTIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<AuthenticatorMethodProperty> getVerifiableProperties() {
        return verifiableProperties;
    }

    @JsonProperty(JSON_PROPERTY_VERIFIABLE_PROPERTIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setVerifiableProperties(List<AuthenticatorMethodProperty> verifiableProperties) {
        this.verifiableProperties = verifiableProperties;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorMethodWithVerifiableProperties authenticatorMethodWithVerifiableProperties = (AuthenticatorMethodWithVerifiableProperties) o;
        return Objects.equals(this.verifiableProperties,
                authenticatorMethodWithVerifiableProperties.verifiableProperties);
        // && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(verifiableProperties, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorMethodWithVerifiableProperties {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    verifiableProperties: ").append(toIndentedString(verifiableProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
