package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies whether the User is to be enrolled the first time they &#x60;LOGIN&#x60;, the next time they are in the
 * &#x60;CHALLENGE&#x60; process, or &#x60;NEVER&#x60;
 */
@ApiModel(description = "Specifies whether the User is to be enrolled the first time they `LOGIN`, the next time they are in the `CHALLENGE` process, or `NEVER`")
@JsonPropertyOrder({ AuthenticatorEnrollmentPolicyRuleActionEnroll.JSON_PROPERTY_SELF })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AuthenticatorEnrollmentPolicyRuleActionEnroll implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Gets or Sets self
     */
    public enum SelfEnum {
        CHALLENGE(String.valueOf("CHALLENGE")),

        LOGIN(String.valueOf("LOGIN")),

        NEVER(String.valueOf("NEVER")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        SelfEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static SelfEnum fromValue(String value) {
            for (SelfEnum b : SelfEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_SELF = "self";
    private SelfEnum self;

    public AuthenticatorEnrollmentPolicyRuleActionEnroll() {
    }

    public AuthenticatorEnrollmentPolicyRuleActionEnroll self(SelfEnum self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SelfEnum getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(SelfEnum self) {
        this.self = self;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AuthenticatorEnrollmentPolicyRuleActionEnroll authenticatorEnrollmentPolicyRuleActionEnroll = (AuthenticatorEnrollmentPolicyRuleActionEnroll) o;
        return Objects.equals(this.self, authenticatorEnrollmentPolicyRuleActionEnroll.self);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(self);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticatorEnrollmentPolicyRuleActionEnroll {\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
