package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AccessPolicyRuleCustomCondition;
import com.okta.sdk.resource.model.DeviceAccessPolicyRuleCondition;
import com.okta.sdk.resource.model.PlatformPolicyRuleCondition;
import com.okta.sdk.resource.model.PolicyNetworkCondition;
import com.okta.sdk.resource.model.PolicyPeopleCondition;
import com.okta.sdk.resource.model.RiskScorePolicyRuleCondition;
import com.okta.sdk.resource.model.UserTypeCondition;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * AccessPolicyRuleConditions
 */
@JsonPropertyOrder({ AccessPolicyRuleConditions.JSON_PROPERTY_DEVICE,
        AccessPolicyRuleConditions.JSON_PROPERTY_EL_CONDITION, AccessPolicyRuleConditions.JSON_PROPERTY_NETWORK,
        AccessPolicyRuleConditions.JSON_PROPERTY_PEOPLE, AccessPolicyRuleConditions.JSON_PROPERTY_PLATFORM,
        AccessPolicyRuleConditions.JSON_PROPERTY_RISK_SCORE, AccessPolicyRuleConditions.JSON_PROPERTY_USER_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AccessPolicyRuleConditions implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DEVICE = "device";
    private DeviceAccessPolicyRuleCondition device;

    public static final String JSON_PROPERTY_EL_CONDITION = "elCondition";
    private AccessPolicyRuleCustomCondition elCondition;

    public static final String JSON_PROPERTY_NETWORK = "network";
    private PolicyNetworkCondition network;

    public static final String JSON_PROPERTY_PEOPLE = "people";
    private PolicyPeopleCondition people;

    public static final String JSON_PROPERTY_PLATFORM = "platform";
    private PlatformPolicyRuleCondition platform;

    public static final String JSON_PROPERTY_RISK_SCORE = "riskScore";
    private RiskScorePolicyRuleCondition riskScore;

    public static final String JSON_PROPERTY_USER_TYPE = "userType";
    private UserTypeCondition userType;

    public AccessPolicyRuleConditions() {
    }

    public AccessPolicyRuleConditions device(DeviceAccessPolicyRuleCondition device) {

        this.device = device;
        return this;
    }

    /**
     * Get device
     *
     * @return device
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_DEVICE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public DeviceAccessPolicyRuleCondition getDevice() {
        return device;
    }

    @JsonProperty(JSON_PROPERTY_DEVICE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDevice(DeviceAccessPolicyRuleCondition device) {
        this.device = device;
    }

    public AccessPolicyRuleConditions elCondition(AccessPolicyRuleCustomCondition elCondition) {

        this.elCondition = elCondition;
        return this;
    }

    /**
     * Get elCondition
     *
     * @return elCondition
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_EL_CONDITION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public AccessPolicyRuleCustomCondition getElCondition() {
        return elCondition;
    }

    @JsonProperty(JSON_PROPERTY_EL_CONDITION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setElCondition(AccessPolicyRuleCustomCondition elCondition) {
        this.elCondition = elCondition;
    }

    public AccessPolicyRuleConditions network(PolicyNetworkCondition network) {

        this.network = network;
        return this;
    }

    /**
     * Get network
     *
     * @return network
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NETWORK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyNetworkCondition getNetwork() {
        return network;
    }

    @JsonProperty(JSON_PROPERTY_NETWORK)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNetwork(PolicyNetworkCondition network) {
        this.network = network;
    }

    public AccessPolicyRuleConditions people(PolicyPeopleCondition people) {

        this.people = people;
        return this;
    }

    /**
     * Get people
     *
     * @return people
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PEOPLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PolicyPeopleCondition getPeople() {
        return people;
    }

    @JsonProperty(JSON_PROPERTY_PEOPLE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPeople(PolicyPeopleCondition people) {
        this.people = people;
    }

    public AccessPolicyRuleConditions platform(PlatformPolicyRuleCondition platform) {

        this.platform = platform;
        return this;
    }

    /**
     * Get platform
     *
     * @return platform
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PLATFORM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PlatformPolicyRuleCondition getPlatform() {
        return platform;
    }

    @JsonProperty(JSON_PROPERTY_PLATFORM)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPlatform(PlatformPolicyRuleCondition platform) {
        this.platform = platform;
    }

    public AccessPolicyRuleConditions riskScore(RiskScorePolicyRuleCondition riskScore) {

        this.riskScore = riskScore;
        return this;
    }

    /**
     * Get riskScore
     *
     * @return riskScore
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RISK_SCORE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RiskScorePolicyRuleCondition getRiskScore() {
        return riskScore;
    }

    @JsonProperty(JSON_PROPERTY_RISK_SCORE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRiskScore(RiskScorePolicyRuleCondition riskScore) {
        this.riskScore = riskScore;
    }

    public AccessPolicyRuleConditions userType(UserTypeCondition userType) {

        this.userType = userType;
        return this;
    }

    /**
     * Get userType
     *
     * @return userType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserTypeCondition getUserType() {
        return userType;
    }

    @JsonProperty(JSON_PROPERTY_USER_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserType(UserTypeCondition userType) {
        this.userType = userType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AccessPolicyRuleConditions accessPolicyRuleConditions = (AccessPolicyRuleConditions) o;
        return Objects.equals(this.device, accessPolicyRuleConditions.device)
                && Objects.equals(this.elCondition, accessPolicyRuleConditions.elCondition)
                && Objects.equals(this.network, accessPolicyRuleConditions.network)
                && Objects.equals(this.people, accessPolicyRuleConditions.people)
                && Objects.equals(this.platform, accessPolicyRuleConditions.platform)
                && Objects.equals(this.riskScore, accessPolicyRuleConditions.riskScore)
                && Objects.equals(this.userType, accessPolicyRuleConditions.userType);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(device, elCondition, network, people, platform, riskScore, userType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccessPolicyRuleConditions {\n");
        sb.append("    device: ").append(toIndentedString(device)).append("\n");
        sb.append("    elCondition: ").append(toIndentedString(elCondition)).append("\n");
        sb.append("    network: ").append(toIndentedString(network)).append("\n");
        sb.append("    people: ").append(toIndentedString(people)).append("\n");
        sb.append("    platform: ").append(toIndentedString(platform)).append("\n");
        sb.append("    riskScore: ").append(toIndentedString(riskScore)).append("\n");
        sb.append("    userType: ").append(toIndentedString(userType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
