/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import java.io.File;
import com.okta.sdk.resource.model.ImageUploadResponse;
import com.okta.sdk.resource.model.ThemeResponse;
import com.okta.sdk.resource.model.UpdateThemeRequest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class ThemesApi {

    private ApiClient apiClient;

    public ThemesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ThemesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Delete the Background Image Deletes a Theme background image
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteBrandThemeBackgroundImage(String brandId, String themeId) throws ApiException {
        this.deleteBrandThemeBackgroundImage(brandId, themeId, Collections.emptyMap());
    }

    /**
     * Delete the Background Image Deletes a Theme background image
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteBrandThemeBackgroundImage(String brandId, String themeId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'brandId' is set
        if (brandId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'brandId' when calling deleteBrandThemeBackgroundImage");
        }

        // verify the required parameter 'themeId' is set
        if (themeId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'themeId' when calling deleteBrandThemeBackgroundImage");
        }

        // create path and map variables
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/background-image"
                .replaceAll("\\{" + "brandId" + "\\}", apiClient.escapeString(brandId.toString()))
                .replaceAll("\\{" + "themeId" + "\\}", apiClient.escapeString(themeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete the Favicon Deletes a Theme favicon. The theme will use the default Okta favicon.
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteBrandThemeFavicon(String brandId, String themeId) throws ApiException {
        this.deleteBrandThemeFavicon(brandId, themeId, Collections.emptyMap());
    }

    /**
     * Delete the Favicon Deletes a Theme favicon. The theme will use the default Okta favicon.
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteBrandThemeFavicon(String brandId, String themeId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'brandId' is set
        if (brandId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'brandId' when calling deleteBrandThemeFavicon");
        }

        // verify the required parameter 'themeId' is set
        if (themeId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'themeId' when calling deleteBrandThemeFavicon");
        }

        // create path and map variables
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/favicon"
                .replaceAll("\\{" + "brandId" + "\\}", apiClient.escapeString(brandId.toString()))
                .replaceAll("\\{" + "themeId" + "\\}", apiClient.escapeString(themeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete the Logo Deletes a Theme logo. The theme will use the default Okta logo.
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteBrandThemeLogo(String brandId, String themeId) throws ApiException {
        this.deleteBrandThemeLogo(brandId, themeId, Collections.emptyMap());
    }

    /**
     * Delete the Logo Deletes a Theme logo. The theme will use the default Okta logo.
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteBrandThemeLogo(String brandId, String themeId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'brandId' is set
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling deleteBrandThemeLogo");
        }

        // verify the required parameter 'themeId' is set
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling deleteBrandThemeLogo");
        }

        // create path and map variables
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/logo"
                .replaceAll("\\{" + "brandId" + "\\}", apiClient.escapeString(brandId.toString()))
                .replaceAll("\\{" + "themeId" + "\\}", apiClient.escapeString(themeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve a Theme Retrieves a theme for a brand
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     *
     * @return ThemeResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ThemeResponse getBrandTheme(String brandId, String themeId) throws ApiException {
        return this.getBrandTheme(brandId, themeId, Collections.emptyMap());
    }

    /**
     * Retrieve a Theme Retrieves a theme for a brand
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ThemeResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ThemeResponse getBrandTheme(String brandId, String themeId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'brandId' is set
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling getBrandTheme");
        }

        // verify the required parameter 'themeId' is set
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling getBrandTheme");
        }

        // create path and map variables
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}"
                .replaceAll("\\{" + "brandId" + "\\}", apiClient.escapeString(brandId.toString()))
                .replaceAll("\\{" + "themeId" + "\\}", apiClient.escapeString(themeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ThemeResponse> localVarReturnType = new TypeReference<ThemeResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Themes Lists all the themes in your brand. &gt; **Important:** Currently each org supports only one
     * Theme, therefore this contains a single object only.
     *
     * @param brandId
     *            The ID of the brand (required)
     *
     * @return List&lt;ThemeResponse&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ThemeResponse> listBrandThemes(String brandId) throws ApiException {
        return this.listBrandThemes(brandId, Collections.emptyMap());
    }

    /**
     * List all Themes Lists all the themes in your brand. &gt; **Important:** Currently each org supports only one
     * Theme, therefore this contains a single object only.
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;ThemeResponse&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<ThemeResponse> listBrandThemes(String brandId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'brandId' is set
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling listBrandThemes");
        }

        // create path and map variables
        String localVarPath = "/api/v1/brands/{brandId}/themes".replaceAll("\\{" + "brandId" + "\\}",
                apiClient.escapeString(brandId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<ThemeResponse>> localVarReturnType = new TypeReference<List<ThemeResponse>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace a Theme Replaces a theme for a brand
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     * @param theme
     *            (required)
     *
     * @return ThemeResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ThemeResponse replaceBrandTheme(String brandId, String themeId, UpdateThemeRequest theme)
            throws ApiException {
        return this.replaceBrandTheme(brandId, themeId, theme, Collections.emptyMap());
    }

    /**
     * Replace a Theme Replaces a theme for a brand
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     * @param theme
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ThemeResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ThemeResponse replaceBrandTheme(String brandId, String themeId, UpdateThemeRequest theme,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = theme;

        // verify the required parameter 'brandId' is set
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling replaceBrandTheme");
        }

        // verify the required parameter 'themeId' is set
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling replaceBrandTheme");
        }

        // verify the required parameter 'theme' is set
        if (theme == null) {
            throw new ApiException(400, "Missing the required parameter 'theme' when calling replaceBrandTheme");
        }

        // create path and map variables
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}"
                .replaceAll("\\{" + "brandId" + "\\}", apiClient.escapeString(brandId.toString()))
                .replaceAll("\\{" + "themeId" + "\\}", apiClient.escapeString(themeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ThemeResponse> localVarReturnType = new TypeReference<ThemeResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload the Background Image Uploads and replaces the background image for the theme. The file must be in PNG,
     * JPG, or GIF format and less than 2 MB in size.
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     * @param _file
     *            (required)
     *
     * @return ImageUploadResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ImageUploadResponse uploadBrandThemeBackgroundImage(String brandId, String themeId, File _file)
            throws ApiException {
        return this.uploadBrandThemeBackgroundImage(brandId, themeId, _file, Collections.emptyMap());
    }

    /**
     * Upload the Background Image Uploads and replaces the background image for the theme. The file must be in PNG,
     * JPG, or GIF format and less than 2 MB in size.
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     * @param _file
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ImageUploadResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ImageUploadResponse uploadBrandThemeBackgroundImage(String brandId, String themeId, File _file,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'brandId' is set
        if (brandId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'brandId' when calling uploadBrandThemeBackgroundImage");
        }

        // verify the required parameter 'themeId' is set
        if (themeId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'themeId' when calling uploadBrandThemeBackgroundImage");
        }

        // verify the required parameter '_file' is set
        if (_file == null) {
            throw new ApiException(400,
                    "Missing the required parameter '_file' when calling uploadBrandThemeBackgroundImage");
        }

        // create path and map variables
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/background-image"
                .replaceAll("\\{" + "brandId" + "\\}", apiClient.escapeString(brandId.toString()))
                .replaceAll("\\{" + "themeId" + "\\}", apiClient.escapeString(themeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        if (_file != null)
            localVarFormParams.put("file", _file);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "multipart/form-data" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ImageUploadResponse> localVarReturnType = new TypeReference<ImageUploadResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload the Favicon Uploads and replaces the favicon for the theme
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     * @param _file
     *            (required)
     *
     * @return ImageUploadResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ImageUploadResponse uploadBrandThemeFavicon(String brandId, String themeId, File _file) throws ApiException {
        return this.uploadBrandThemeFavicon(brandId, themeId, _file, Collections.emptyMap());
    }

    /**
     * Upload the Favicon Uploads and replaces the favicon for the theme
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     * @param _file
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ImageUploadResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ImageUploadResponse uploadBrandThemeFavicon(String brandId, String themeId, File _file,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'brandId' is set
        if (brandId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'brandId' when calling uploadBrandThemeFavicon");
        }

        // verify the required parameter 'themeId' is set
        if (themeId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'themeId' when calling uploadBrandThemeFavicon");
        }

        // verify the required parameter '_file' is set
        if (_file == null) {
            throw new ApiException(400, "Missing the required parameter '_file' when calling uploadBrandThemeFavicon");
        }

        // create path and map variables
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/favicon"
                .replaceAll("\\{" + "brandId" + "\\}", apiClient.escapeString(brandId.toString()))
                .replaceAll("\\{" + "themeId" + "\\}", apiClient.escapeString(themeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        if (_file != null)
            localVarFormParams.put("file", _file);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "multipart/form-data" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ImageUploadResponse> localVarReturnType = new TypeReference<ImageUploadResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Upload the Logo Uploads and replaces the logo for the theme. The file must be in PNG, JPG, or GIF format and less
     * than 100kB in size. For best results use landscape orientation, a transparent background, and a minimum size of
     * 300px by 50px to prevent upscaling.
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     * @param _file
     *            (required)
     *
     * @return ImageUploadResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ImageUploadResponse uploadBrandThemeLogo(String brandId, String themeId, File _file) throws ApiException {
        return this.uploadBrandThemeLogo(brandId, themeId, _file, Collections.emptyMap());
    }

    /**
     * Upload the Logo Uploads and replaces the logo for the theme. The file must be in PNG, JPG, or GIF format and less
     * than 100kB in size. For best results use landscape orientation, a transparent background, and a minimum size of
     * 300px by 50px to prevent upscaling.
     *
     * @param brandId
     *            The ID of the brand (required)
     * @param themeId
     *            The ID of the theme (required)
     * @param _file
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return ImageUploadResponse
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public ImageUploadResponse uploadBrandThemeLogo(String brandId, String themeId, File _file,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'brandId' is set
        if (brandId == null) {
            throw new ApiException(400, "Missing the required parameter 'brandId' when calling uploadBrandThemeLogo");
        }

        // verify the required parameter 'themeId' is set
        if (themeId == null) {
            throw new ApiException(400, "Missing the required parameter 'themeId' when calling uploadBrandThemeLogo");
        }

        // verify the required parameter '_file' is set
        if (_file == null) {
            throw new ApiException(400, "Missing the required parameter '_file' when calling uploadBrandThemeLogo");
        }

        // create path and map variables
        String localVarPath = "/api/v1/brands/{brandId}/themes/{themeId}/logo"
                .replaceAll("\\{" + "brandId" + "\\}", apiClient.escapeString(brandId.toString()))
                .replaceAll("\\{" + "themeId" + "\\}", apiClient.escapeString(themeId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        if (_file != null)
            localVarFormParams.put("file", _file);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "multipart/form-data" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<ImageUploadResponse> localVarReturnType = new TypeReference<ImageUploadResponse>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
