/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.Error;
import com.okta.sdk.resource.model.ListSubscriptionsRoleRoleRefParameter;
import com.okta.sdk.resource.model.NotificationType;
import com.okta.sdk.resource.model.Subscription;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class SubscriptionApi {

    private ApiClient apiClient;

    public SubscriptionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Retrieve a Subscription for a Role Retrieves a subscription by &#x60;notificationType&#x60; for a specified Role
     *
     * @param roleRef
     *            A reference to an existing role. Standard roles require a &#x60;roleType&#x60;, while Custom Roles
     *            require a &#x60;roleId&#x60;. See [Standard
     *            Roles](/openapi/okta-management/guides/roles/#standard-roles). (required)
     * @param notificationType
     *            (required)
     *
     * @return Subscription
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Subscription getSubscriptionsNotificationTypeRole(ListSubscriptionsRoleRoleRefParameter roleRef,
            NotificationType notificationType) throws ApiException {
        return this.getSubscriptionsNotificationTypeRole(roleRef, notificationType, Collections.emptyMap());
    }

    /**
     * Retrieve a Subscription for a Role Retrieves a subscription by &#x60;notificationType&#x60; for a specified Role
     *
     * @param roleRef
     *            A reference to an existing role. Standard roles require a &#x60;roleType&#x60;, while Custom Roles
     *            require a &#x60;roleId&#x60;. See [Standard
     *            Roles](/openapi/okta-management/guides/roles/#standard-roles). (required)
     * @param notificationType
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Subscription
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Subscription getSubscriptionsNotificationTypeRole(ListSubscriptionsRoleRoleRefParameter roleRef,
            NotificationType notificationType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'roleRef' is set
        if (roleRef == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleRef' when calling getSubscriptionsNotificationTypeRole");
        }

        // verify the required parameter 'notificationType' is set
        if (notificationType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'notificationType' when calling getSubscriptionsNotificationTypeRole");
        }

        // create path and map variables
        String localVarPath = "/api/v1/roles/{roleRef}/subscriptions/{notificationType}"
                .replaceAll("\\{" + "roleRef" + "\\}", apiClient.escapeString(roleRef.toString()))
                .replaceAll("\\{" + "notificationType" + "\\}", apiClient.escapeString(notificationType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Subscription> localVarReturnType = new TypeReference<Subscription>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Retrieve a Subscription for a User Retrieves a subscription by &#x60;notificationType&#x60; for a specified User.
     * Returns an &#x60;AccessDeniedException&#x60; message if requests are made for another user.
     *
     * @param notificationType
     *            (required)
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @return Subscription
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Subscription getSubscriptionsNotificationTypeUser(NotificationType notificationType, String userId)
            throws ApiException {
        return this.getSubscriptionsNotificationTypeUser(notificationType, userId, Collections.emptyMap());
    }

    /**
     * Retrieve a Subscription for a User Retrieves a subscription by &#x60;notificationType&#x60; for a specified User.
     * Returns an &#x60;AccessDeniedException&#x60; message if requests are made for another user.
     *
     * @param notificationType
     *            (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return Subscription
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public Subscription getSubscriptionsNotificationTypeUser(NotificationType notificationType, String userId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'notificationType' is set
        if (notificationType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'notificationType' when calling getSubscriptionsNotificationTypeUser");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling getSubscriptionsNotificationTypeUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/subscriptions/{notificationType}"
                .replaceAll("\\{" + "notificationType" + "\\}", apiClient.escapeString(notificationType.toString()))
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<Subscription> localVarReturnType = new TypeReference<Subscription>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Subscriptions for a Role Lists all subscriptions available to a specified Role
     *
     * @param roleRef
     *            A reference to an existing role. Standard roles require a &#x60;roleType&#x60;, while Custom Roles
     *            require a &#x60;roleId&#x60;. See [Standard
     *            Roles](/openapi/okta-management/guides/roles/#standard-roles). (required)
     *
     * @return List&lt;Subscription&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Subscription> listSubscriptionsRole(ListSubscriptionsRoleRoleRefParameter roleRef) throws ApiException {
        return this.listSubscriptionsRole(roleRef, Collections.emptyMap());
    }

    /**
     * List all Subscriptions for a Role Lists all subscriptions available to a specified Role
     *
     * @param roleRef
     *            A reference to an existing role. Standard roles require a &#x60;roleType&#x60;, while Custom Roles
     *            require a &#x60;roleId&#x60;. See [Standard
     *            Roles](/openapi/okta-management/guides/roles/#standard-roles). (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;Subscription&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Subscription> listSubscriptionsRole(ListSubscriptionsRoleRoleRefParameter roleRef,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'roleRef' is set
        if (roleRef == null) {
            throw new ApiException(400, "Missing the required parameter 'roleRef' when calling listSubscriptionsRole");
        }

        // create path and map variables
        String localVarPath = "/api/v1/roles/{roleRef}/subscriptions".replaceAll("\\{" + "roleRef" + "\\}",
                apiClient.escapeString(roleRef.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<Subscription>> localVarReturnType = new TypeReference<List<Subscription>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Subscriptions for a User Lists all subscriptions available to a specified User. Returns an
     * &#x60;AccessDeniedException&#x60; message if requests are made for another user.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @return List&lt;Subscription&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Subscription> listSubscriptionsUser(String userId) throws ApiException {
        return this.listSubscriptionsUser(userId, Collections.emptyMap());
    }

    /**
     * List all Subscriptions for a User Lists all subscriptions available to a specified User. Returns an
     * &#x60;AccessDeniedException&#x60; message if requests are made for another user.
     *
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;Subscription&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<Subscription> listSubscriptionsUser(String userId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listSubscriptionsUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/subscriptions".replaceAll("\\{" + "userId" + "\\}",
                apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<Subscription>> localVarReturnType = new TypeReference<List<Subscription>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Subscribe a Role to a Specific Notification Type Subscribes a Role to a specified notification type. Changes to
     * Role subscriptions override the subscription status of any individual users with the Role.
     *
     * @param roleRef
     *            A reference to an existing role. Standard roles require a &#x60;roleType&#x60;, while Custom Roles
     *            require a &#x60;roleId&#x60;. See [Standard
     *            Roles](/openapi/okta-management/guides/roles/#standard-roles). (required)
     * @param notificationType
     *            (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void subscribeByNotificationTypeRole(ListSubscriptionsRoleRoleRefParameter roleRef,
            NotificationType notificationType) throws ApiException {
        this.subscribeByNotificationTypeRole(roleRef, notificationType, Collections.emptyMap());
    }

    /**
     * Subscribe a Role to a Specific Notification Type Subscribes a Role to a specified notification type. Changes to
     * Role subscriptions override the subscription status of any individual users with the Role.
     *
     * @param roleRef
     *            A reference to an existing role. Standard roles require a &#x60;roleType&#x60;, while Custom Roles
     *            require a &#x60;roleId&#x60;. See [Standard
     *            Roles](/openapi/okta-management/guides/roles/#standard-roles). (required)
     * @param notificationType
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void subscribeByNotificationTypeRole(ListSubscriptionsRoleRoleRefParameter roleRef,
            NotificationType notificationType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'roleRef' is set
        if (roleRef == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleRef' when calling subscribeByNotificationTypeRole");
        }

        // verify the required parameter 'notificationType' is set
        if (notificationType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'notificationType' when calling subscribeByNotificationTypeRole");
        }

        // create path and map variables
        String localVarPath = "/api/v1/roles/{roleRef}/subscriptions/{notificationType}/subscribe"
                .replaceAll("\\{" + "roleRef" + "\\}", apiClient.escapeString(roleRef.toString()))
                .replaceAll("\\{" + "notificationType" + "\\}", apiClient.escapeString(notificationType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Subscribe a User to a Specific Notification Type Subscribes the current User to a specified notification type.
     * Returns an &#x60;AccessDeniedException&#x60; message if requests are made for another user.
     *
     * @param notificationType
     *            (required)
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void subscribeByNotificationTypeUser(NotificationType notificationType, String userId) throws ApiException {
        this.subscribeByNotificationTypeUser(notificationType, userId, Collections.emptyMap());
    }

    /**
     * Subscribe a User to a Specific Notification Type Subscribes the current User to a specified notification type.
     * Returns an &#x60;AccessDeniedException&#x60; message if requests are made for another user.
     *
     * @param notificationType
     *            (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void subscribeByNotificationTypeUser(NotificationType notificationType, String userId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'notificationType' is set
        if (notificationType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'notificationType' when calling subscribeByNotificationTypeUser");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling subscribeByNotificationTypeUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/subscriptions/{notificationType}/subscribe"
                .replaceAll("\\{" + "notificationType" + "\\}", apiClient.escapeString(notificationType.toString()))
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Unsubscribe a Role from a Specific Notification Type Unsubscribes a Role from a specified notification type.
     * Changes to Role subscriptions override the subscription status of any individual users with the Role.
     *
     * @param roleRef
     *            A reference to an existing role. Standard roles require a &#x60;roleType&#x60;, while Custom Roles
     *            require a &#x60;roleId&#x60;. See [Standard
     *            Roles](/openapi/okta-management/guides/roles/#standard-roles). (required)
     * @param notificationType
     *            (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unsubscribeByNotificationTypeRole(ListSubscriptionsRoleRoleRefParameter roleRef,
            NotificationType notificationType) throws ApiException {
        this.unsubscribeByNotificationTypeRole(roleRef, notificationType, Collections.emptyMap());
    }

    /**
     * Unsubscribe a Role from a Specific Notification Type Unsubscribes a Role from a specified notification type.
     * Changes to Role subscriptions override the subscription status of any individual users with the Role.
     *
     * @param roleRef
     *            A reference to an existing role. Standard roles require a &#x60;roleType&#x60;, while Custom Roles
     *            require a &#x60;roleId&#x60;. See [Standard
     *            Roles](/openapi/okta-management/guides/roles/#standard-roles). (required)
     * @param notificationType
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unsubscribeByNotificationTypeRole(ListSubscriptionsRoleRoleRefParameter roleRef,
            NotificationType notificationType, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'roleRef' is set
        if (roleRef == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'roleRef' when calling unsubscribeByNotificationTypeRole");
        }

        // verify the required parameter 'notificationType' is set
        if (notificationType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'notificationType' when calling unsubscribeByNotificationTypeRole");
        }

        // create path and map variables
        String localVarPath = "/api/v1/roles/{roleRef}/subscriptions/{notificationType}/unsubscribe"
                .replaceAll("\\{" + "roleRef" + "\\}", apiClient.escapeString(roleRef.toString()))
                .replaceAll("\\{" + "notificationType" + "\\}", apiClient.escapeString(notificationType.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Unsubscribe a User from a Specific Notification Type Unsubscribes the current User from a specified notification
     * type. Returns an &#x60;AccessDeniedException&#x60; message if requests are made for another user.
     *
     * @param notificationType
     *            (required)
     * @param userId
     *            ID of an existing Okta user (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unsubscribeByNotificationTypeUser(NotificationType notificationType, String userId)
            throws ApiException {
        this.unsubscribeByNotificationTypeUser(notificationType, userId, Collections.emptyMap());
    }

    /**
     * Unsubscribe a User from a Specific Notification Type Unsubscribes the current User from a specified notification
     * type. Returns an &#x60;AccessDeniedException&#x60; message if requests are made for another user.
     *
     * @param notificationType
     *            (required)
     * @param userId
     *            ID of an existing Okta user (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void unsubscribeByNotificationTypeUser(NotificationType notificationType, String userId,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'notificationType' is set
        if (notificationType == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'notificationType' when calling unsubscribeByNotificationTypeUser");
        }

        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'userId' when calling unsubscribeByNotificationTypeUser");
        }

        // create path and map variables
        String localVarPath = "/api/v1/users/{userId}/subscriptions/{notificationType}/unsubscribe"
                .replaceAll("\\{" + "notificationType" + "\\}", apiClient.escapeString(notificationType.toString()))
                .replaceAll("\\{" + "userId" + "\\}", apiClient.escapeString(userId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
