/*
 * Okta Admin Management
 * Allows customers to easily access the Okta Management APIs
 *
 * The version of the OpenAPI document: 2024.08.3
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.okta.sdk.resource.api;

import com.fasterxml.jackson.core.type.TypeReference;

import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.model.*;
import com.okta.sdk.resource.client.Pair;

import com.okta.sdk.resource.model.AuthorizationServer;
import com.okta.sdk.resource.model.Error;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;

import org.openapitools.jackson.nullable.JsonNullableModule;

@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-05-05T16:46:15.395194+05:30[Asia/Kolkata]", comments = "Generator version: 7.11.0")
public class AuthorizationServerApi {

    private ApiClient apiClient;

    public AuthorizationServerApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Activate an Authorization Server Activates an authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateAuthorizationServer(String authServerId) throws ApiException {
        this.activateAuthorizationServer(authServerId, Collections.emptyMap());
    }

    /**
     * Activate an Authorization Server Activates an authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void activateAuthorizationServer(String authServerId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling activateAuthorizationServer");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/lifecycle/activate"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Create an Authorization Server Creates an authorization server
     *
     * @param authorizationServer
     *            (required)
     *
     * @return AuthorizationServer
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServer createAuthorizationServer(AuthorizationServer authorizationServer) throws ApiException {
        return this.createAuthorizationServer(authorizationServer, Collections.emptyMap());
    }

    /**
     * Create an Authorization Server Creates an authorization server
     *
     * @param authorizationServer
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthorizationServer
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServer createAuthorizationServer(AuthorizationServer authorizationServer,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = authorizationServer;

        // verify the required parameter 'authorizationServer' is set
        if (authorizationServer == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authorizationServer' when calling createAuthorizationServer");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthorizationServer> localVarReturnType = new TypeReference<AuthorizationServer>() {
        };
        return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Deactivate an Authorization Server Deactivates an authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateAuthorizationServer(String authServerId) throws ApiException {
        this.deactivateAuthorizationServer(authServerId, Collections.emptyMap());
    }

    /**
     * Deactivate an Authorization Server Deactivates an authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deactivateAuthorizationServer(String authServerId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling deactivateAuthorizationServer");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/lifecycle/deactivate"
                .replaceAll("\\{" + "authServerId" + "\\}", apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Delete an Authorization Server Deletes an authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteAuthorizationServer(String authServerId) throws ApiException {
        this.deleteAuthorizationServer(authServerId, Collections.emptyMap());
    }

    /**
     * Delete an Authorization Server Deletes an authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public void deleteAuthorizationServer(String authServerId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling deleteAuthorizationServer");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}".replaceAll("\\{" + "authServerId" + "\\}",
                apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    /**
     * Retrieve an Authorization Server Retrieves an authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     *
     * @return AuthorizationServer
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServer getAuthorizationServer(String authServerId) throws ApiException {
        return this.getAuthorizationServer(authServerId, Collections.emptyMap());
    }

    /**
     * Retrieve an Authorization Server Retrieves an authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthorizationServer
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServer getAuthorizationServer(String authServerId, Map<String, String> additionalHeaders)
            throws ApiException {
        Object localVarPostBody = null;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling getAuthorizationServer");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}".replaceAll("\\{" + "authServerId" + "\\}",
                apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthorizationServer> localVarReturnType = new TypeReference<AuthorizationServer>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * List all Authorization Servers Lists all custom authorization servers in the org
     *
     * @param q
     *            Searches the &#x60;name&#x60; and &#x60;audiences&#x60; of authorization servers for matching values
     *            (optional)
     * @param limit
     *            Specifies the number of authorization server results on a page. Maximum value: 200 (optional, default
     *            to 200)
     * @param after
     *            Specifies the pagination cursor for the next page of authorization servers. Treat as an opaque value
     *            and obtain through the next link relationship. (optional)
     *
     * @return List&lt;AuthorizationServer&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServer> listAuthorizationServers(String q, Integer limit, String after)
            throws ApiException {
        return this.listAuthorizationServers(q, limit, after, Collections.emptyMap());
    }

    /**
     * List all Authorization Servers Lists all custom authorization servers in the org
     *
     * @param q
     *            Searches the &#x60;name&#x60; and &#x60;audiences&#x60; of authorization servers for matching values
     *            (optional)
     * @param limit
     *            Specifies the number of authorization server results on a page. Maximum value: 200 (optional, default
     *            to 200)
     * @param after
     *            Specifies the pagination cursor for the next page of authorization servers. Treat as an opaque value
     *            and obtain through the next link relationship. (optional)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return List&lt;AuthorizationServer&gt;
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public List<AuthorizationServer> listAuthorizationServers(String q, Integer limit, String after,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers";

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarQueryParams.addAll(apiClient.parameterToPair("q", q));
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(apiClient.parameterToPair("after", after));

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<List<AuthorizationServer>> localVarReturnType = new TypeReference<List<AuthorizationServer>>() {
        };
        return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Replace an Authorization Server Replaces an authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param authorizationServer
     *            (required)
     *
     * @return AuthorizationServer
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServer replaceAuthorizationServer(String authServerId, AuthorizationServer authorizationServer)
            throws ApiException {
        return this.replaceAuthorizationServer(authServerId, authorizationServer, Collections.emptyMap());
    }

    /**
     * Replace an Authorization Server Replaces an authorization server
     *
     * @param authServerId
     *            &#x60;id&#x60; of the Authorization Server (required)
     * @param authorizationServer
     *            (required)
     * @param additionalHeaders
     *            additionalHeaders for this call
     *
     * @return AuthorizationServer
     *
     * @throws ApiException
     *             if fails to make API call
     */
    public AuthorizationServer replaceAuthorizationServer(String authServerId, AuthorizationServer authorizationServer,
            Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = authorizationServer;

        // verify the required parameter 'authServerId' is set
        if (authServerId == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authServerId' when calling replaceAuthorizationServer");
        }

        // verify the required parameter 'authorizationServer' is set
        if (authorizationServer == null) {
            throw new ApiException(400,
                    "Missing the required parameter 'authorizationServer' when calling replaceAuthorizationServer");
        }

        // create path and map variables
        String localVarPath = "/api/v1/authorizationServers/{authServerId}".replaceAll("\\{" + "authServerId" + "\\}",
                apiClient.escapeString(authServerId.toString()));

        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        String localVarQueryParameterBaseName;
        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        localVarHeaderParams.putAll(additionalHeaders);

        final String[] localVarAccepts = { "application/json" };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

        final String[] localVarContentTypes = { "application/json" };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] { "apiToken", "oauth2" };

        TypeReference<AuthorizationServer> localVarReturnType = new TypeReference<AuthorizationServer>() {
        };
        return apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams,
                localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams,
                localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.registerModule(new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }

}
