# UserGrantApi

All URIs are relative to *https://subdomain.okta.com*

| Method | HTTP request | Description |
|------------- | ------------- | -------------|
| [**getUserGrant**](UserGrantApi.md#getUserGrant) | **GET** /api/v1/users/{userId}/grants/{grantId} | Retrieve a User Grant |
| [**listGrantsForUserAndClient**](UserGrantApi.md#listGrantsForUserAndClient) | **GET** /api/v1/users/{userId}/clients/{clientId}/grants | List all Grants for a Client |
| [**listUserGrants**](UserGrantApi.md#listUserGrants) | **GET** /api/v1/users/{userId}/grants | List all User Grants |
| [**revokeGrantsForUserAndClient**](UserGrantApi.md#revokeGrantsForUserAndClient) | **DELETE** /api/v1/users/{userId}/clients/{clientId}/grants | Revoke all Grants for a Client |
| [**revokeUserGrant**](UserGrantApi.md#revokeUserGrant) | **DELETE** /api/v1/users/{userId}/grants/{grantId} | Revoke a User Grant |
| [**revokeUserGrants**](UserGrantApi.md#revokeUserGrants) | **DELETE** /api/v1/users/{userId}/grants | Revoke all User Grants |



## getUserGrant

> OAuth2ScopeConsentGrant getUserGrant(userId, grantId, expand)

Retrieve a User Grant

Retrieves a Grant for the specified User

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserGrantApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserGrantApi apiInstance = new UserGrantApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String grantId = "iJoqkwx50mrgX4T9LcaH"; // String | Grant ID
        String expand = "scope"; // String | Valid value: `scope`. If specified, scope details are included in the `_embedded` attribute.
        try {
            OAuth2ScopeConsentGrant result = apiInstance.getUserGrant(userId, grantId, expand);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserGrantApi#getUserGrant");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **grantId** | **String**| Grant ID | |
| **expand** | **String**| Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60; attribute. | [optional] |

### Return type

[**OAuth2ScopeConsentGrant**](OAuth2ScopeConsentGrant.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listGrantsForUserAndClient

> List&lt;OAuth2ScopeConsentGrant&gt; listGrantsForUserAndClient(userId, clientId, expand, after, limit)

List all Grants for a Client

Lists all Grants for a specified User and client

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserGrantApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserGrantApi apiInstance = new UserGrantApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        String expand = "expand_example"; // String | Valid value: `scope`. If specified, scope details are included in the `_embedded` attribute.
        String after = "after_example"; // String | The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the `Link` response header. See [Pagination](https://developer.okta.com/docs/api/#pagination).
        Integer limit = 20; // Integer | Specifies the number of tokens to return
        try {
            List<OAuth2ScopeConsentGrant> result = apiInstance.listGrantsForUserAndClient(userId, clientId, expand, after, limit);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserGrantApi#listGrantsForUserAndClient");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |
| **expand** | **String**| Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60; attribute. | [optional] |
| **after** | **String**| The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](https://developer.okta.com/docs/api/#pagination). | [optional] |
| **limit** | **Integer**| Specifies the number of tokens to return | [optional] [default to 20] |

### Return type

[**List&lt;OAuth2ScopeConsentGrant&gt;**](OAuth2ScopeConsentGrant.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## listUserGrants

> List&lt;OAuth2ScopeConsentGrant&gt; listUserGrants(userId, scopeId, expand, after, limit)

List all User Grants

Lists all Grants for the specified user

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserGrantApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserGrantApi apiInstance = new UserGrantApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String scopeId = "scopeId_example"; // String | The scope ID to filter on
        String expand = "scope"; // String | Valid value: `scope`. If specified, scope details are included in the `_embedded` attribute.
        String after = "after_example"; // String | The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the `Link` response header. See [Pagination](https://developer.okta.com/docs/api/#pagination).
        Integer limit = 20; // Integer | Specifies the number of grants to return
        try {
            List<OAuth2ScopeConsentGrant> result = apiInstance.listUserGrants(userId, scopeId, expand, after, limit);
            System.out.println(result);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserGrantApi#listUserGrants");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **scopeId** | **String**| The scope ID to filter on | [optional] |
| **expand** | **String**| Valid value: &#x60;scope&#x60;. If specified, scope details are included in the &#x60;_embedded&#x60; attribute. | [optional] |
| **after** | **String**| The cursor to use for pagination. It is an opaque string that specifies your current location in the list and is obtained from the &#x60;Link&#x60; response header. See [Pagination](https://developer.okta.com/docs/api/#pagination). | [optional] |
| **limit** | **Integer**| Specifies the number of grants to return | [optional] [default to 20] |

### Return type

[**List&lt;OAuth2ScopeConsentGrant&gt;**](OAuth2ScopeConsentGrant.md)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **200** | Success |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## revokeGrantsForUserAndClient

> revokeGrantsForUserAndClient(userId, clientId)

Revoke all Grants for a Client

Revokes all Grants for the specified User and client

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserGrantApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserGrantApi apiInstance = new UserGrantApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String clientId = "52Uy4BUWVBOjFItcg2jWsmnd83Ad8dD"; // String | `client_id` of the app
        try {
            apiInstance.revokeGrantsForUserAndClient(userId, clientId);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserGrantApi#revokeGrantsForUserAndClient");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **clientId** | **String**| &#x60;client_id&#x60; of the app | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## revokeUserGrant

> revokeUserGrant(userId, grantId)

Revoke a User Grant

Revokes one Grant for a specified User

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserGrantApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserGrantApi apiInstance = new UserGrantApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        String grantId = "iJoqkwx50mrgX4T9LcaH"; // String | Grant ID
        try {
            apiInstance.revokeUserGrant(userId, grantId);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserGrantApi#revokeUserGrant");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |
| **grantId** | **String**| Grant ID | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |


## revokeUserGrants

> revokeUserGrants(userId)

Revoke all User Grants

Revokes all Grants for a specified User

### Example

```java
// Import classes:
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.auth.*;
import com.okta.sdk.resource.client.models.*;
import com.okta.sdk.resource.api.UserGrantApi;

public class Example {
    public static void main(String[] args) {
        ApiClient defaultClient = Configuration.getDefaultApiClient();
        defaultClient.setBasePath("https://subdomain.okta.com");
        
        // Configure API key authorization: apiToken
        ApiKeyAuth apiToken = (ApiKeyAuth) defaultClient.getAuthentication("apiToken");
        apiToken.setApiKey("YOUR API KEY");
        // Uncomment the following line to set a prefix for the API key, e.g. "Token" (defaults to null)
        //apiToken.setApiKeyPrefix("Token");

        // Configure OAuth2 access token for authorization: oauth2
        OAuth oauth2 = (OAuth) defaultClient.getAuthentication("oauth2");
        oauth2.setAccessToken("YOUR ACCESS TOKEN");

        UserGrantApi apiInstance = new UserGrantApi(defaultClient);
        String userId = "00ub0oNGTSWTBKOLGLNR"; // String | ID of an existing Okta user
        try {
            apiInstance.revokeUserGrants(userId);
        } catch (ApiException e) {
            System.err.println("Exception when calling UserGrantApi#revokeUserGrants");
            System.err.println("Status code: " + e.getCode());
            System.err.println("Reason: " + e.getResponseBody());
            System.err.println("Response headers: " + e.getResponseHeaders());
            e.printStackTrace();
        }
    }
}
```

### Parameters


| Name | Type | Description  | Notes |
|------------- | ------------- | ------------- | -------------|
| **userId** | **String**| ID of an existing Okta user | |

### Return type

null (empty response body)

### Authorization

[apiToken](../README.md#apiToken), [oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
| **204** | No Content |  -  |
| **403** | Forbidden |  -  |
| **404** | Not Found |  -  |
| **429** | Too Many Requests |  -  |

